import { NgModule } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router, RouterModule, Routes } from '@angular/router';


import { Title, Meta } from '@angular/platform-browser';
import { filter, map } from 'rxjs/operators';
import { DashboardSkeletonComponent } from './pages/dashboard-skeleton/dashboard-skeleton.component';
import { AboutUsPageComponent } from './pages/about-us/about-us-page.component';
import { LoginComponent } from './pages/login/login.component';
import { AdminDashboardComponent } from './pages/admin/admin-dashboard/admin-dashboard.component';
import { AdminLandingComponent } from './pages/admin/admin-landing/admin-landing.component';
import { AdministratorDetailsComponent } from './pages/admin/administrator/administrator-details/administrator-details.component';
import { AdministratorListComponent } from './pages/admin/administrator/administrator-list/administrator-list.component';
import { AdministratorOnboardingComponent } from './pages/admin/administrator/administrator-onboarding/administrator-onboarding.component';
import { MemberDetailsComponent } from './pages/admin/member/member-details/member-details.component';
import { MemberListComponent } from './pages/admin/member/member-list/member-list.component';
import { MemberOnboardingComponent } from './pages/admin/member/member-onboarding/member-onboarding.component';
import { TicketComponent } from './pages/admin/ticket/ticket.component';
import { TraderDetailsComponent } from './pages/admin/trader/trader-details/trader-details.component';
import { TraderListComponent } from './pages/admin/trader/trader-list/trader-list.component';
import { TradingAccountDetailsComponent } from './pages/admin/trader/trading-account-details/trading-account-details.component';
import { TradingTokensComponent } from './pages/admin/trader/trading-tokens/trading-tokens.component';
import { TrustedSourceDetailsComponent } from './pages/admin/trusted-source/trusted-source-details/trusted-source-details.component';
import { TrustedSourceListComponent } from './pages/admin/trusted-source/trusted-source-list/trusted-source-list.component';
import { TrustedSourceOnboardingComponent } from './pages/admin/trusted-source/trusted-source-onboarding/trusted-source-onboarding.component';
import { AssetPublishmentComponent } from './pages/asset-publishment/asset-publishment.component';
import { FdacComponent } from './pages/fdac/fdac.component';
import { HelpdeskPageComponent } from './pages/helpdesk/helpdesk-page.component';
import { HomePageComponent } from './pages/home-page/home-page.component';
import { LandingPageEndUserComponent } from './pages/landing-page-end-user/landing-page-end-user.component';
import { LearningCentreComponent } from './pages/learning-centre/learning-centre.component';
import { MemberLoginComponent } from './pages/member-login/member-login.component';
import { PolicyComponent } from './pages/policy/policy.component';
import { AccountRedemptionComponent } from './pages/profile-page-account/account-redemption/account-redemption.component';
import { AccountTerminationComponent } from './pages/profile-page-account/account-termination/account-termination.component';
import { AccountTokensComponent } from './pages/profile-page-account/account-tokens/account-tokens.component';
import { AccountTradesComponent } from './pages/profile-page-account/account-trades/account-trades.component';
import { ProfilePageAccountComponent } from './pages/profile-page-account/profile-page-account.component';
import { ProfilePageAssetComponent } from './pages/profile-page-asset/profile-page-asset.component';
import { ProfilePageOverviewComponent } from './pages/profile-page-overview/profile-page-overview.component';
import { ProfilePageReviewComponent } from './pages/profile-page-review/profile-page-review.component';
import { ProfilePageTicketComponent } from './pages/profile-page-ticket/profile-page-ticket.component';
import { ProfilePageTradeComponent } from './pages/profile-page-trade/profile-page-trade.component';
import { RegisterYourselfComponent } from './pages/register-yourself/register-yourself.component';
import { SearchPageComponent } from './pages/search-page/search-page.component';
import { ComponentDetailsWithHeader } from './components/component-details/component-details-with-header.component';
import { ValidationDetailsWithHeader } from './components/validation-details/validation-details-with-header.component';
import { OfferingDetailstComponent } from './pages/offering-details/offering-details.component';
import { OfferingDefinitionComponent } from './pages/offering-definition/offering-definition.component';
import { PatComponent } from './pages/pat/pat.component';

const routes: Routes = [
  {
    path: '',
    component: HomePageComponent,
    data: { title: 'Home Page', description: 'Home page', keywords: 'home, angular' }
  },
  {
    path: 'landing-page-end-user',
    component: LandingPageEndUserComponent,
    data: { title: 'Landing Page End User', description: 'Landing page', keywords: 'Landing Page, angular' }
  },
  {
    path: 'dashboard-skeleton',
    component: DashboardSkeletonComponent,
    data: { title: 'Dashboard Skeleton', description: 'Dashboard Skeleton', keywords: 'Dashboard Skeleton, angular' }
  },
  {
    path: 'about-us',
    component: AboutUsPageComponent,
    data: { title: 'About Us', description: 'About Us', keywords: 'About Us, angular' }
  },
  {
    path: 'helpdesk',
    component: HelpdeskPageComponent,
    data: { title: 'Helpdesk', description: 'Helpdesk', keywords: 'Helpdesk, angular' }
  },
  // {
  //   path: 'offering-details',
  //   component: OfferingDetailsComponent,
  //   data: { title: 'Offering Details', description: 'Offering Details', keywords: 'Offering Details, angular' }
  // },
  {
    path: 'login',
    component: LoginComponent,
    data: { title: 'Login', description: 'Login', keywords: 'Login, angular' }
  },
  {
    path: 'policy',
    component: PolicyComponent,
    data: { title: 'Policy', description: 'Policy', keywords: 'Policy, angular' }
  },
  {
    path: 'register-yourself',
    component: RegisterYourselfComponent,
    data: { title: 'Register Yourself', description: 'Register Yourself', keywords: 'Register Yourself, angular' }
  },
  {
    path: 'account-redemption',
    component: AccountRedemptionComponent,
    data: { title: 'account redemption', description: 'account redemption', keywords: 'account redemption, angular' }
  },
  {
    path: 'account-termination',
    component: AccountTerminationComponent,
    data: { title: 'account termination', description: 'account termination', keywords: 'account termination, angular' }
  },
  {
    path: 'account-tokens',
    component: AccountTokensComponent,
    data: { title: 'account tokens', description: 'account tokens', keywords: 'account tokens, angular' }
  },
  {
    path: 'account-trades',
    component: AccountTradesComponent,
    data: { title: 'account trades', description: 'account trades', keywords: 'account trades, angular' }
  },

  // profile pages
  {
    path: 'profile-overview',
    component: ProfilePageOverviewComponent,
    data: { title: 'Profile Overview', description: 'Profile Overview', keywords: 'Profile Overview, angular' }
  },
  {
    path: 'profile-account',
    component: ProfilePageAccountComponent,
    data: { title: 'Profile Account', description: 'Profile Account', keywords: 'Profile Account, angular' }
  },
  {
    path: 'profile-asset',
    component: ProfilePageAssetComponent,
    data: { title: 'Profile Asset', description: 'Profile Asset', keywords: 'Profile Asset, angular' }
  },
  {
    path: 'profile-trade',
    component: ProfilePageTradeComponent,
    data: { title: 'Profile Trade', description: 'Profile Trade', keywords: 'Profile Trade, angular' }
  },
  {
    path: 'profile-review',
    component: ProfilePageReviewComponent,
    data: { title: 'Profile Review', description: 'Profile Review', keywords: 'Profile Review, angular' }
  },
  {
    path: 'profile-ticket',
    component: ProfilePageTicketComponent,
    data: { title: 'Profile Ticket', description: 'Profile Ticket', keywords: 'Profile Ticket, angular' }
  },

  // empty pages
  {
    path: 'member-login',
    component: MemberLoginComponent,
    data: { title: 'Member Login', description: 'Member Login', keywords: 'Member Login, angular' }
  },
  {
    path: 'asset-publishment',
    component: AssetPublishmentComponent,
    data: { title: 'Asset Publishment', description: 'Asset Publishment', keywords: 'Asset Publishment, angular' }
  },
  {
    path: 'search',
    component: SearchPageComponent,
    data: { title: 'Search', description: 'Search', keywords: 'Search, angular' }
  },
  {
    path: 'fdac',
    component: FdacComponent,
    data: { title: 'FDAC', description: 'FDAC', keywords: 'FDAC, angular' }
  },
  {
    path: 'learning-centre',
    component: LearningCentreComponent,
    data: { title: 'Learning Centre', description: 'Learning Centre', keywords: 'Learning Centre, angular' }
  },
  {
    path: 'asset/:id',
    component: ComponentDetailsWithHeader,
    data: { title: 'Asset', description: 'Asset', keywords: 'IoT Catalogue, asset' }
  },
  {
    path: 'learning-centre',
    component: LearningCentreComponent,
    data: { title: 'Learning Centre', description: 'Learning Centre', keywords: 'Learning Centre, angular' }
  },
  {
    path: 'validation/:id',
    component: ValidationDetailsWithHeader,
    data: { title: 'Validation', description: 'Validation', keywords: 'IoT Catalogue, validation' }
  },


  // admin
  {
    path: 'admin-dashboard',
    component: AdminDashboardComponent,
  },
  {
    path: 'admin-landing',
    component: AdminLandingComponent,
  },
  {
    path: 'administrator-details',
    component: AdministratorDetailsComponent,
    data: { title: 'Administrator details', description: 'Administrator details', keywords: 'administrator-details, angular', breadcrumb: 'details' }
  },
  {
    path: 'administrator-list',
    component: AdministratorListComponent,
    data: { title: 'Administrator List', description: 'Administrator List', keywords: 'administrator-list, angular', breadcrumb: 'list' }
  },
  {
    path: 'administrator-onboarding',
    component: AdministratorOnboardingComponent,
    data: { title: 'Administrator onboarding', description: 'Administrator onboarding', keywords: 'administrator-onboarding, angular', breadcrumb: 'onboarding' }
  },

  {
    path: 'member-details',
    component: MemberDetailsComponent,
  },
  {
    path: 'member-list',
    component: MemberListComponent,
  },
  {
    path: 'member-onboarding',
    component: MemberOnboardingComponent,
  },

  {
    path: 'ticket',
    component: TicketComponent,
  },

  {
    path: 'trader-details',
    component: TraderDetailsComponent,
  },
  {
    path: 'trader-list',
    component: TraderListComponent,
  },
  {
    path: 'trading-account-details',
    component: TradingAccountDetailsComponent,
  },
  {
    path: 'trading-tokens',
    component: TradingTokensComponent,
  },

  {
    path: 'trusted-source-details',
    component: TrustedSourceDetailsComponent,
  },
  {
    path: 'trusted-source-list',
    component: TrustedSourceListComponent,
  },
  {
    path: 'trusted-source-onboarding',
    component: TrustedSourceOnboardingComponent,
  },
  {
    path: 'offering-definition',
    component: OfferingDefinitionComponent,
  },
  {
    path: 'offering-details',
    component: OfferingDetailstComponent,
  },
  // {
  //   path: 'offering-details/:id',
  //   component: OfferingDetailstComponent,
  // },

  {
    path: 'pat',
    component: PatComponent,
  },

  { path: 'login', component: LoginComponent }, // Add login route

];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {
  constructor(private titleService: Title, private metaService: Meta, private router: Router, private activatedRoute: ActivatedRoute) {
    this.router.events.pipe(
      filter(event => event instanceof NavigationEnd),
      map(() => {
        let child = this.activatedRoute.firstChild;
        while (child?.firstChild) {
          child = child.firstChild;
        }
        return child?.snapshot.data;
      })
    ).subscribe(data => {
      if (data && data['title']) {
        this.titleService.setTitle(data['title']);
      }
      if (data && data['description']) {
        this.metaService.updateTag({ name: 'description', content: data['description'] });
      }
      if (data && data['keywords']) {
        this.metaService.updateTag({ name: 'keywords', content: data['keywords'] });
      }
    });
  }
 }
