import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';

import { NavigationBarComponent } from '../app/components/navigation-bar/navigation-bar.component';
import { FooterSectionComponent } from '../app/components/footer-section/footer-section.component';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { StickyMenuComponent } from './components/sticky-menu/sticky-menu.component';

import { MatInputModule } from '@angular/material/input';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonModule } from '@angular/material/button';
import { MatExpansionModule } from '@angular/material/expansion';
import { MatSidenavModule } from '@angular/material/sidenav';
import { MatListModule } from '@angular/material/list';
import { MatToolbarModule } from '@angular/material/toolbar';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatSelectModule } from '@angular/material/select';
import { MatDialogModule } from '@angular/material/dialog';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatNativeDateModule } from '@angular/material/core';
import { MatFormFieldModule } from '@angular/material/form-field';
import { JsonPipe, NgIf } from '@angular/common';

import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { MatChipsModule } from '@angular/material/chips';
import { MatTableModule } from '@angular/material/table';
import { MatPaginatorModule } from '@angular/material/paginator';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { MatCardModule } from '@angular/material/card';

import { NgxChartsModule } from '@swimlane/ngx-charts';
import { DashboardSkeletonComponent } from './pages/dashboard-skeleton/dashboard-skeleton.component';

import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { CommonModule } from '@angular/common';
import { QRCodeModule } from 'angularx-qrcode';
import { AuthorizationqrPopupComponent } from './components/authorizationqr-popup/authorizationqr-popup.component';
import { AuthenticationComponent } from './components/authentication/authentication.component';
import { AboutUsPageComponent } from './pages/about-us/about-us-page.component';
import { LoginComponent } from './pages/login/login.component';
import { HomePageComponent } from './pages/home-page/home-page.component';
import { LandingPageEndUserComponent } from './pages/landing-page-end-user/landing-page-end-user.component';
import { HelpdeskPageComponent } from './pages/helpdesk/helpdesk-page.component';
import { RegisterYourselfComponent } from './pages/register-yourself/register-yourself.component';
import { PolicyComponent } from './pages/policy/policy.component';
import { AccountRedemptionComponent } from './pages/profile-page-account/account-redemption/account-redemption.component';
import { AccountTerminationComponent } from './pages/profile-page-account/account-termination/account-termination.component';
import { AccountTokensComponent } from './pages/profile-page-account/account-tokens/account-tokens.component';
import { AccountTradesComponent } from './pages/profile-page-account/account-trades/account-trades.component';
import { BreadcrumbComponent } from './components/breadcrumb/breadcrumb.component';
import { DialogNewTicketComponent } from './components/dialog-new-ticket/dialog-new-ticket.component';
import { DialogOfferingLogComponent } from './components/dialog-offering-log/dialog-offering-log.component';
import { DialogPublishingLogComponent } from './components/dialog-publishing-log/dialog-publishing-log.component';
import { DialogTradingLogComponent } from './components/dialog-trading-log/dialog-trading-log.component';
import { DialogTrendingLogComponent } from './components/dialog-trending-log/dialog-trending-log.component';
import { DialogViewTicketComponent } from './components/dialog-view-ticket/dialog-view-ticket.component';
import { FooterSectionAdminComponent } from './components/footer-section-admin/footer-section-admin.component';
import { NavigationBarAdminComponent } from './components/navigation-bar-admin/navigation-bar-admin.component';
import { NavigationBarFdacComponent } from './components/navigation-bar-fdac/navigation-bar-fdac.component';
import { NavigationBarLcComponent } from './components/navigation-bar-lc/navigation-bar-lc.component';
import { ResponsiveSidenavAdminComponent } from './components/responsive-sidenav-admin/responsive-sidenav-admin.component';
import { ResponsiveSidenavEndUserComponent } from './components/responsive-sidenav-end-user/responsive-sidenav-end-user.component';
import { ResponsiveSidenavComponent } from './components/responsive-sidenav/responsive-sidenav.component';
import { ScrollTopComponent } from './components/scroll-top/scroll-top.component';
import { SidenavComponent } from './components/sidenav/sidenav.component';
import { AdminDashboardComponent } from './pages/admin/admin-dashboard/admin-dashboard.component';
import { AdminLandingComponent } from './pages/admin/admin-landing/admin-landing.component';
import { AdministratorDetailsComponent } from './pages/admin/administrator/administrator-details/administrator-details.component';
import { AdministratorListComponent } from './pages/admin/administrator/administrator-list/administrator-list.component';
import { AdministratorOnboardingComponent } from './pages/admin/administrator/administrator-onboarding/administrator-onboarding.component';
import { MemberDetailsComponent } from './pages/admin/member/member-details/member-details.component';
import { MemberListComponent } from './pages/admin/member/member-list/member-list.component';
import { MemberOnboardingComponent } from './pages/admin/member/member-onboarding/member-onboarding.component';
import { TicketComponent } from './pages/admin/ticket/ticket.component';
import { TraderDetailsComponent } from './pages/admin/trader/trader-details/trader-details.component';
import { TraderListComponent } from './pages/admin/trader/trader-list/trader-list.component';
import { TradingAccountDetailsComponent } from './pages/admin/trader/trading-account-details/trading-account-details.component';
import { TradingTokensComponent } from './pages/admin/trader/trading-tokens/trading-tokens.component';
import { TrustedSourceDetailsComponent } from './pages/admin/trusted-source/trusted-source-details/trusted-source-details.component';
import { TrustedSourceListComponent } from './pages/admin/trusted-source/trusted-source-list/trusted-source-list.component';
import { TrustedSourceOnboardingComponent } from './pages/admin/trusted-source/trusted-source-onboarding/trusted-source-onboarding.component';
import { AssetPublishmentComponent } from './pages/asset-publishment/asset-publishment.component';
import { FdacComponent } from './pages/fdac/fdac.component';
import { LearningCentreComponent } from './pages/learning-centre/learning-centre.component';
import { MemberLoginComponent } from './pages/member-login/member-login.component';
import { ProfilePageAccountComponent } from './pages/profile-page-account/profile-page-account.component';
import { ProfilePageAssetComponent } from './pages/profile-page-asset/profile-page-asset.component';
import { ProfilePageOverviewComponent } from './pages/profile-page-overview/profile-page-overview.component';
import { ProfilePageReviewComponent } from './pages/profile-page-review/profile-page-review.component';
import { ProfilePageTicketComponent } from './pages/profile-page-ticket/profile-page-ticket.component';
import { ProfilePageTradeComponent } from './pages/profile-page-trade/profile-page-trade.component';
import { SearchPageComponent } from './pages/search-page/search-page.component';
import { BubblePaginationDirective } from './pagination.directive';
import { ComponentDetailsWithHeader } from './components/component-details/component-details-with-header.component';
import { ValidationDetailsWithHeader } from './components/validation-details/validation-details-with-header.component';
import { ComponentDetails } from './components/component-details/component-details.component';
import { ComponentList } from './components/component-list/component-list.component';
import { TrainingList } from './components/training-list/training-list.component';
import { ValidationDetails } from './components/validation-details/validation-details.component';
import { OfferingDetailstComponent } from './pages/offering-details/offering-details.component';

import { InputTextModule } from 'primeng/inputtext';
import { ButtonModule } from 'primeng/button';
import { SliderModule } from 'primeng/slider';
import { DropdownModule } from 'primeng/dropdown';
import { CardModule } from 'primeng/card';
import { DividerModule } from 'primeng/divider';
import { KnobModule } from 'primeng/knob';

import { HTTP_INTERCEPTORS, HttpClientModule } from '@angular/common/http';
import { SearchResultsComponent } from './components/search-results/search-results.component';
import { OfferingDefinitionComponent } from './pages/offering-definition/offering-definition.component';
import { PatComponent } from './pages/pat/pat.component';
import {MatRadioModule} from "@angular/material/radio";
import { MatSnackBarModule } from '@angular/material/snack-bar';
import {MatGridListModule} from "@angular/material/grid-list";
import { HeaderInterceptor } from './services/header-interceptor';



@NgModule({
  declarations: [
    AppComponent,
    DashboardSkeletonComponent,
    AboutUsPageComponent,
    FooterSectionComponent,
    StickyMenuComponent,
    AuthorizationqrPopupComponent,
    AuthenticationComponent,

    HomePageComponent,
    LandingPageEndUserComponent,
    HelpdeskPageComponent,
    AboutUsPageComponent,

    // OfferingDetailsComponent,

    // new add empty pages
    RegisterYourselfComponent,
    PolicyComponent,
    // LoginComponent,
    AccountRedemptionComponent,
    AccountTerminationComponent,
    AccountTokensComponent,
    AccountTradesComponent,

    // profile pages
    ProfilePageOverviewComponent,
    ProfilePageTradeComponent,
    ProfilePageTicketComponent,
    ProfilePageReviewComponent,
    ProfilePageAssetComponent,
    ProfilePageAccountComponent,

    // empty pages
    MemberLoginComponent,
    AssetPublishmentComponent,
    SearchPageComponent,

    OfferingDefinitionComponent,
    OfferingDetailstComponent,
    PatComponent,


    // Added plugin pages
    FdacComponent,
    LearningCentreComponent,

    // admin
    AdminDashboardComponent,
    AdminLandingComponent,
    AdministratorDetailsComponent,
    AdministratorListComponent,
    AdministratorOnboardingComponent,

    MemberDetailsComponent,
    MemberListComponent,
    MemberOnboardingComponent,

    TicketComponent,

    TraderDetailsComponent,
    TraderListComponent,
    TradingAccountDetailsComponent,
    TradingTokensComponent,

    TrustedSourceDetailsComponent,
    TrustedSourceListComponent,
    TrustedSourceOnboardingComponent,

    // components
    // NavigationBarComponent,
    FooterSectionComponent,
    StickyMenuComponent,
    SidenavComponent,
    ResponsiveSidenavComponent,
    DialogNewTicketComponent,
    ScrollTopComponent,
    ResponsiveSidenavEndUserComponent,
    ResponsiveSidenavAdminComponent,
    FooterSectionAdminComponent,
    NavigationBarAdminComponent,
    DialogPublishingLogComponent,
    DialogOfferingLogComponent,
    DialogTrendingLogComponent,
    DialogTradingLogComponent,
    NavigationBarLcComponent,
    NavigationBarFdacComponent,
    DialogViewTicketComponent,
    SearchResultsComponent,

    BreadcrumbComponent,

    // directive
    BubblePaginationDirective,

    LoginComponent,

    ComponentDetailsWithHeader,
    ValidationDetailsWithHeader

  ],
    imports: [
        BrowserModule,
        AppRoutingModule,
        BrowserAnimationsModule,
        HttpClientModule,
        QRCodeModule,
        MatInputModule,
        MatIconModule,
        MatButtonModule,
        MatExpansionModule,
        MatSidenavModule,
        MatListModule,
        MatToolbarModule,
        MatSelectModule,
        FormsModule,
        ReactiveFormsModule,
        MatDialogModule,
        MatDatepickerModule,
        MatNativeDateModule,
        MatFormFieldModule,
        NgIf,
        JsonPipe,
        MatButtonToggleModule,
        MatChipsModule,
        MatTableModule,
        MatPaginatorModule,
        MatSlideToggleModule,
        MatCardModule,
        MatSnackBarModule,
        // chart
        NgxChartsModule,

        // out animations
        NoopAnimationsModule,
        CommonModule,
        NavigationBarComponent,

        ComponentList,
        ComponentDetails,
        ValidationDetails,
        TrainingList,

        InputTextModule,
        ButtonModule,
        SliderModule,
        DropdownModule,
        CardModule,
        DividerModule,
        KnobModule,

        //BE Integration
        // HttpClientModule,
        MatRadioModule,
        MatGridListModule

    ],
  providers: [{
    provide: HTTP_INTERCEPTORS,
    useClass: HeaderInterceptor,
    multi: true
  }],
  bootstrap: [AppComponent],
})
export class AppModule {}
