import { Injectable } from '@angular/core';

@Injectable({
  providedIn: 'root',
})
export class AuthService {
  private jwtTokenKey = 'jwt';

  setToken(token: string): void {
    sessionStorage.setItem(this.jwtTokenKey, token);
  }

  getToken(): string | null {
    return sessionStorage.getItem(this.jwtTokenKey);
  }

  clearToken(): void {
    sessionStorage.removeItem(this.jwtTokenKey);
  }
}