import { createAgent } from "@veramo/core";
import {
  IQRCodeGenerator,
  QrCodeProvider,
} from "@sphereon/ssi-sdk.qr-code-generator";
import {
  ISIOPv2OID4VPRPRestClient,
  SIOPv2OID4VPRPRestClient,
} from "@sphereon/ssi-sdk.siopv2-oid4vp-rp-rest-client";
import { environment } from '../../../environments/environment';

const agent = createAgent<IQRCodeGenerator & ISIOPv2OID4VPRPRestClient>({
  plugins: [
    new QrCodeProvider(),
    new SIOPv2OID4VPRPRestClient({
      baseUrl: environment.backendBaseUri,
      definitionId: environment.presentationDefId ?? 'sphereonGuest',
      authentication: {
        enabled: environment.authenticationEnabled === true || environment.authenticationStaticToken !== undefined,
        bearerToken: environment.authenticationStaticToken,
      },
    }),
  ],
});
export default agent;