import { Component } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { CommonService } from 'src/Services/common.service';
import {
  CredentialMapper,
  UniformVerifiablePresentation,
} from '@sphereon/ssi-types';
import { AuthService } from 'src/app/auth/auth.service';
import { Router } from '@angular/router';

@Component({
  selector: 'app-authorizationqr-popup',
  templateUrl: './authorizationqr-popup.component.html',
  styleUrls: ['./authorizationqr-popup.component.scss'],
})
export class AuthorizationqrPopupComponent {
  finalData: any;

  constructor(
    public dialogRef: MatDialogRef<AuthorizationqrPopupComponent>,
    private commonService: CommonService,
    private authService: AuthService,
    private router: Router
  ) {
    this.commonService.refinedEvent.subscribe((value) => {
      this.cancel();
      this.wrapperPresentation(value);
    });
  }

  cancel() {
    this.dialogRef.close();
  }

  wrapperPresentation(payload: any) {
    const wrappedPresentation =
      CredentialMapper.toWrappedVerifiablePresentation(
        Array.isArray(payload.vp_token)
          ? payload.vp_token[0]
          : payload.vp_token!
      );
    console.log(wrappedPresentation);
    const presentation =
      wrappedPresentation?.presentation as UniformVerifiablePresentation;
    const subjects =
      presentation?.verifiableCredential[0].credential.credentialSubject;
    const subject = Array.isArray(subjects) ? subjects[0] : subjects!;
    const proofs = presentation?.verifiableCredential[0].credential.proof;
    let jwtPayload = JSON.stringify(proofs);
    const jsonDataPayload = JSON.parse(jwtPayload);
    const jwt = jsonDataPayload.jwt;
    this.authService.setToken(jwt);
    console.log(sessionStorage);
    this.commonService.popCloseEvent.emit(subject);
    this.router.navigate(['/']); // Redirect to the desired page
  }
}
