import { Component, CUSTOM_ELEMENTS_SCHEMA, ElementRef, inject } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent } from '../iframe/iframe.component';

import { ActivatedRoute } from '@angular/router';
import { IframeProps } from 'src/app/services/iot-cat.service';
@Component({
    selector: 'component-details',
    standalone: true,

    imports: [CommonModule, IframeComponent],
    template: `

    <div [ngStyle]="{'max-width':'1100px','margin':'0 auto'} " >
        <iframe-component [iframeProps]="this.iframeProps"></iframe-component>
    </div>
    `,
    styleUrls: [],
})
export class ComponentDetails {
    iframeProps: IframeProps
    route: ActivatedRoute = inject(ActivatedRoute);

    constructor() {
        this.iframeProps = { path: `/components/${this.route.snapshot.params['id']}` }
    }
}