import { Component, ElementRef, inject, ViewChild } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent } from '../iframe/iframe.component';
import { Loading } from '../iframe/loading.component';
import { IframeProps, IoTCatService } from 'src/app/services/iot-cat.service';
import { PolicyIntegrationService } from 'src/app/services/policy-integration.service';
import { NavigationBarComponent } from '../navigation-bar/navigation-bar.component';
import { NavigationBarFdacComponent } from '../navigation-bar-fdac/navigation-bar-fdac.component';
@Component({
    selector: 'component-list',
    standalone: true,
    imports: [CommonModule, IframeComponent, Loading],
    template: `
   

  <div *ngIf="this.iframeProps === null">
    <loading-component ></loading-component>
    </div>

    <div style="margin-top:1rem;margin-left:2rem;margin-right:2rem" *ngIf="this.iframeProps !== null">
        <iframe-component #iframe class=" bg-black" [iframeProps]="this.iframeProps"></iframe-component>
    </div>

`,
    styleUrls: ["./component-list.component.scss"],
})
export class ComponentList {
    iframeProps: IframeProps | null
    ioTCatService: IoTCatService = inject(IoTCatService);
    policyIntegrationService: PolicyIntegrationService = inject(PolicyIntegrationService);
    iframe: IframeComponent | null = null
    authorizedIds: string[] | null
    @ViewChild("iframe")
    set appShark(el: IframeComponent) {

        this.iframe = el
    };
    constructor() {
        this.authorizedIds = null
        this.iframeProps = null
    }



    async ngOnInit() {
        const response = await this.ioTCatService.getElementsIdInfo("components")
        //@ts-ignore
        const ids = response.map(el => el._id)
        this.authorizedIds = await this.policyIntegrationService.authorizeIds(ids, "components")
        this.iframeProps = {
            path: "/componentListNoBar",
            requests: [
                {
                    id: "componentList",
                    json: {
                        filter: { _id: { $in: this.authorizedIds } }
                    }
                }
            ]
        }
    }
}