import { Component, Inject, OnInit } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';

export interface OfferingLogEntry {
  oid: string;
  type: string;
  aid: string;
  ts: string;
}

@Component({
  selector: 'app-dialog-offering-log',
  templateUrl: './dialog-offering-log.component.html',
  styleUrls: ['./dialog-offering-log.component.scss']
})
export class DialogOfferingLogComponent implements OnInit {
  displayedColumns: string[] = ['oid', 'type', 'aid', 'ts'];
  dataSource = new MatTableDataSource<OfferingLogEntry>();
  totalLength = 100; // Set the total length according to your data
  searchQuery: string = '';
  selectedSort: string = 'newest';

  constructor(
    public dialogRef: MatDialogRef<DialogOfferingLogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: OfferingLogEntry[]
  ) {}

  ngOnInit(): void {
    this.dataSource.data = this.data;
  }

  onClose(): void {
    this.dialogRef.close();
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getTypeClass(type: string): string {
    switch (type) {
      case 'SUBSCRIPTION':
        return 'subscription';
      default:
        return '';
    }
  }
}