import { Component, Inject, OnInit } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';

export interface TrendingLogEntry {
  oid: string;
  type: string;
  aid: string;
  turnover: number;
}

@Component({
  selector: 'app-dialog-trending-log',
  templateUrl: './dialog-trending-log.component.html',
  styleUrls: ['./dialog-trending-log.component.scss']
})
export class DialogTrendingLogComponent implements OnInit {
  displayedColumns: string[] = ['oid', 'type', 'aid', 'turnover'];
  dataSource = new MatTableDataSource<TrendingLogEntry>();
  totalLength = 100; // Set the total length according to your data
  searchQuery: string = '';
  selectedSort: string = 'newest';
  selectedTrending: string = 'week';

  constructor(
    public dialogRef: MatDialogRef<DialogTrendingLogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: TrendingLogEntry[]
  ) {}

  ngOnInit(): void {
    this.dataSource.data = this.data;
  }

  onClose(): void {
    this.dialogRef.close();
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  trendData(): void {
    // Implement trending logic based on selectedTrending
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getTypeClass(type: string): string {
    switch (type) {
      case 'SUBSCRIPTION':
        return 'subscription';
      default:
        return '';
    }
  }
}