import { Component, ContentChild, ElementRef, inject, Input, ViewChild, ViewContainerRef } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DomSanitizer, SafeResourceUrl } from '@angular/platform-browser';


import { IframeProps, IoTCatService } from 'src/app/services/iot-cat.service';
import { Loading } from './loading.component';
@Component({
    selector: 'iframe-component',
    standalone: true,
    imports: [CommonModule, Loading],
    template: `
        <section class="container">
            <iframe #contentChild [ngStyle]="{ 'width':'100%', 'border':0,'height.px': this.height}" [src]="sanitizedUrl" border="0"></iframe>
        </section>
      

    `,
    styleUrls: [],
})


export class IframeComponent {
    @Input() iframeProps!: IframeProps;
    sanitizedUrl: SafeResourceUrl = this.getSanitizedURL("");
    ioTCatService: IoTCatService = inject(IoTCatService);
    height: number = 0
    dom: HTMLIFrameElement | null = null
    @ViewChild("contentChild")
    set appShark(el: ElementRef<HTMLIFrameElement>) {

        this.dom = el.nativeElement
    };
    getSanitizedURL(url: string): SafeResourceUrl {
        return this.domSanitizer.bypassSecurityTrustResourceUrl(url);
    }
    constructor(private domSanitizer: DomSanitizer) {
        this.processMessage = this.processMessage.bind(this)
        //@ts-ignore
        window.iframe = this


    }

    sendMessage(msg: any) {
        if (!this.dom) return
        this.dom.contentWindow?.postMessage(msg, "*")
    }

    processMessage(event: MessageEvent) {
        const data = event.data
        if (data.action === "resize") {
            this.height = data.height
        }
    }
    async ngOnInit() {
        const url = await this.ioTCatService.getIframeURL(this.iframeProps)
        this.sanitizedUrl = this.getSanitizedURL(url)
        window.addEventListener("message", this.processMessage, false)
    }

    ngOnDestroy() {
        window.removeEventListener("message", this.processMessage)
    }

}