import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { CommonService } from 'src/Services/common.service';
import { AuthService } from 'src/app/auth/auth.service';

@Component({
  selector: 'app-navigation-bar-lc',
  templateUrl: './navigation-bar-lc.component.html',
  styleUrls: ['./navigation-bar-lc.component.scss']
})
export class NavigationBarLcComponent implements OnInit {

  menuOpen: boolean = false;
  userLogin: any;
  buttonState: boolean = false;
  logoState: boolean = true;

  toggleMenu() {
    this.menuOpen = !this.menuOpen;
  }

  constructor(
    private commonService: CommonService,
    private authService: AuthService,
    private router: Router
  ) {
    this.commonService.popCloseEvent.subscribe((value) => {
      this.userLogin = value?.firstName + value?.lastName;
      this.buttonState = true;
      this.logoState = false;
    });
  }

  ngOnInit() {
    this.checkLoginStatus();
  }

  checkLoginStatus() {
    const token = this.authService.getToken();
    if (token) {
      this.buttonState = true;
      this.logoState = false;
    } else {
      this.buttonState = false;
      this.logoState = true;
    }
  }

  redirectToLogin() {
    this.router.navigate(['/login']); // Redirect to login page
  }

  SignOut() {
    this.authService.clearToken();
    this.logoState = true;
    this.buttonState = false;
    this.router.navigate(['/']); // Redirect to home page or login page
  }

  navigateTo(page: string) {
    if (this.buttonState) {
      this.router.navigate([page]);
    } else {
      this.redirectToLogin();
    }
  }

}
