import { Component, OnInit } from '@angular/core';
import { CommonService } from 'src/Services/common.service';
import { Router } from '@angular/router';
import { AuthService } from 'src/app/auth/auth.service';
import { MatButtonModule } from '@angular/material/button';
import { MatDividerModule } from '@angular/material/divider';
import { MatIconModule } from '@angular/material/icon';
import { CommonModule } from '@angular/common';

@Component({
  selector: 'app-navigation-bar',
  templateUrl: './navigation-bar.component.html',
  styleUrls: ['./navigation-bar.component.scss'],
  standalone: true,
  imports: [MatButtonModule, MatDividerModule, MatIconModule, CommonModule],
})
export class NavigationBarComponent implements OnInit {
  menuOpen: boolean = false;
  userLogin: any;
  // TODO change from false to true - skip auth
  buttonState: boolean = true;
  logoState: boolean = true;

  toggleMenu() {
    this.menuOpen = !this.menuOpen;
  }

  constructor(
    private commonService: CommonService,
    private authService: AuthService,
    private router: Router
  ) {
    this.commonService.popCloseEvent.subscribe((value) => {
      this.userLogin = value?.firstName + value?.lastName;
      this.buttonState = true;
      this.logoState = false;
    });
  }

  ngOnInit() {
    // TODO comment below - skip auth
    this.checkLoginStatus();
  }

  checkLoginStatus() {
    const token = this.authService.getToken();
    if (token) {
      this.buttonState = true;
      this.logoState = false;
    } else {
      this.buttonState = false;
      this.logoState = true;
    }
  }

  redirectToLogin() {
    this.router.navigate(['/login']); // Redirect to login page
  }

  SignOut() {
    this.authService.clearToken();
    this.logoState = true;
    this.buttonState = false;
    this.router.navigate(['/']); // Redirect to home page or login page
  }

  navigateTo(page: string) {
    if (this.buttonState) {
      this.router.navigate([page]);
    } else {
      // TODO comment below - skip auth
      this.redirectToLogin();
    }
  }
}
