import { Component, ViewChild, AfterViewInit, OnInit } from '@angular/core';
import { BreakpointObserver } from '@angular/cdk/layout';
import { MatSidenav } from '@angular/material/sidenav';
import { delay, filter } from 'rxjs/operators';
import { NavigationEnd, Router } from '@angular/router';
import { UntilDestroy, untilDestroyed } from '@ngneat/until-destroy';
import { AuthService } from 'src/app/auth/auth.service';
import { CommonService } from 'src/Services/common.service';

@UntilDestroy()
@Component({
  selector: 'app-responsive-sidenav-end-user',
  templateUrl: './responsive-sidenav-end-user.component.html',
  styleUrls: ['./responsive-sidenav-end-user.component.scss'],
})
export class ResponsiveSidenavEndUserComponent implements AfterViewInit, OnInit {
  @ViewChild(MatSidenav)
  sidenav!: MatSidenav;

  menuOpen: boolean = false;
  userLogin: any;
  buttonState: boolean = false;
  logoState: boolean = true;

  activeLink: string = '/';

  constructor(private observer: BreakpointObserver, private router: Router,private commonService: CommonService,
    private authService: AuthService,) {
    // Listen to route changes to update the active link
    this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        this.activeLink = this.router.url;
      }
    });
    this.commonService.popCloseEvent.subscribe((value) => {
      this.userLogin = value?.firstName + value?.lastName;
      this.buttonState = true;
      this.logoState = false;
    });
  }

  ngOnInit() {
    this.checkLoginStatus();
  }

  ngAfterViewInit() {
    this.observer
      .observe(['(max-width: 800px)'])
      .pipe(untilDestroyed(this))
      .subscribe((res) => {
        //@ts-ignore
        if (res.matches) {
          this.sidenav.mode = 'over';
          this.sidenav.close();
        } else {
          this.sidenav.mode = 'side';
          this.sidenav.open();
        }
      });

    this.router.events
      .pipe(
        untilDestroyed(this),
        filter((e) => e instanceof NavigationEnd)
      )
      .subscribe(() => {
        if (this.sidenav.mode === 'over') {
          this.sidenav.close();
        }
      });
  }

  setActiveLink(link: string): void {
    this.activeLink = link;
  }

  checkLoginStatus() {
    const token = this.authService.getToken();
    if (token) {
      this.buttonState = true;
      this.logoState = false;
    } else {
      this.buttonState = false;
      this.logoState = true;
    }
  }

  redirectToLogin() {
    this.router.navigate(['/login']); // Redirect to login page
  }

  SignOut() {
    this.authService.clearToken();
    this.logoState = true;
    this.buttonState = false;
    this.router.navigate(['/']); // Redirect to home page or login page
  }

  navigateTo(page: string) {
    if (this.buttonState) {
      this.router.navigate([page]);
    } else {
      this.redirectToLogin();
    }
  }
}