import { Component, Input, OnInit } from '@angular/core';
import { Router } from '@angular/router';

@Component({
  selector: 'app-search-results',
  templateUrl: './search-results.component.html',
  styleUrls: ['./search-results.component.scss']
})
export class SearchResultsComponent implements OnInit {
  @Input() response: any[] = [];
  total: number = 0;

  constructor(private router: Router) {}

  ngOnInit(): void {
    this.total = this.response.length;

    // Ensure weight is formatted to two decimal places
    this.response = this.response.map(item => ({
      ...item,
      weight: +item.weight.toFixed(2)
    }));

    // Log the IDs of the assets returned in the search results
    this.response.forEach(item => {
      console.log(item.dataElement.id);
    });
  }

  onMouseOver(event: Event): void {
    // Add hover effect, if necessary
    const target = event.target as HTMLElement;
    target.style.cursor = 'pointer';
  }

  onMouseOut(event: Event): void {
    // Remove hover effect, if necessary
    const target = event.target as HTMLElement;
    target.style.cursor = 'default';
  }

  onTitleClick(id: string): void {
    // const url = this.router.createUrlTree([`/asset/${id}`]).toString();
    // const id = 'e68a05c3ef4635b16a2925a0';  // Example specific ID
    const url = this.router.createUrlTree([`/asset/${id}`]).toString();
    window.open(url, '_blank');
  }
}
