import { Component, CUSTOM_ELEMENTS_SCHEMA, ElementRef, inject } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent } from '../iframe/iframe.component';

import { ActivatedRoute } from '@angular/router';
import { Loading } from '../iframe/loading.component';
import { IOT_CAT_URL } from 'src/app/services/iot-cat.service';
@Component({
    selector: 'training-list',
    standalone: true,

    imports: [CommonModule, IframeComponent, Loading],
    template: `
    <div style="padding:2rem">
        <div  class="iotcat-course-slider" data-items-per-slide="6" data-color="334F65">  
            <loading-component></loading-component>
        </div>

    </div>
 

    `,
    styleUrls: [],
})
export class TrainingList {
    baseURL: string = IOT_CAT_URL
    iotcat_inc_id: number = 1;
    constructor() {


    }
    getIoTCatWidgetId() {
        return "iotcat-widget-" + (this.iotcat_inc_id++)
    }

    processColor(color: string) {
        if (color && color.startsWith("#")) {
            return color.substring(1)
        }
        return color
    }
    populateSliders(path: string, className: string) {
        const sliders: HTMLDivElement[] = Array.from(document.getElementsByClassName(className)) as HTMLDivElement[];
        console.log("slider", sliders)
        for (const slider of sliders) {

            const domId = this.getIoTCatWidgetId()

            const url = this.getSliderIframeURL(domId, path, slider.dataset);
            console.log(url)
            if (url) {
                slider.outerHTML = `<iframe id="${domId}" class="iotcat-iframe" style="border:none;" width="100%" height="0px" src="${url}"></iframe>`
            }
        }
    }

    getSliderIframeURL(domId: string, path: string, dataset: any): string {
        const { type, name, itemsPerSlide, color, appUrl, backgroundColor, id, predicateIds, autoGrid } = dataset
        const _appUrl = appUrl || this.baseURL

        let url = `${_appUrl}/widgets/${path}?type=${type}&domId=${domId}`
        if (itemsPerSlide) {
            url = `${url}&itemsPerSlide=${itemsPerSlide}`
        }
        if (color) {
            url = `${url}&color=${this.processColor(color)}`
        }
        if (id) {
            url = `${url}&id=${id}`
        }
        if (backgroundColor) {
            url = `${url}&bgColor=${this.processColor(backgroundColor)}`
        }
        if (name) {
            url = `${url}&name=${name}`
        }
        if (predicateIds) {
            url = `${url}&predicateIds=${predicateIds}`
        }
        if (autoGrid) {
            url = `${url}&autoGrid=${autoGrid}`
        }

        return url

    }
    receiveMessage(event: MessageEvent) {
        const data = event.data

        if (data.action === "resize") {
            const id = data.id
            const element = document.getElementById(id);
            if (element) {
                element.style.height = data.height + 'px';
            }

        }
    }
    ngOnInit() {


        this.populateSliders("course-slider", "iotcat-course-slider")

        window.addEventListener("message", this.receiveMessage, false)
        window.onbeforeunload = function () {

        };
    }

    ngOnDestroy() {
        window.removeEventListener("message", this.receiveMessage);
    }
}