import { Component, OnInit, AfterViewInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { ViewportScroller } from '@angular/common';
import { AuthorizationqrPopupComponent } from 'src/app/components/authorizationqr-popup/authorizationqr-popup.component';
import { AuthService } from 'src/app/auth/auth.service';
@Component({
  selector: 'app-about-us-page',
  templateUrl: './about-us-page.component.html',
  styleUrls: ['./about-us-page.component.scss']
})
export class AboutUsPageComponent implements OnInit, AfterViewInit  {

  constructor(
    private route: ActivatedRoute,
    private viewportScroller: ViewportScroller,
    private authService: AuthService
  ) { }

  ngOnInit(): void {
    const token = this.authService.getToken();
    if (token) {
      // console.log('JWT Token:', token);
      // Use the token as needed
    }
  }

  ngAfterViewInit(): void {
    this.route.fragment.subscribe(fragment => {
      if (fragment) {
        this.viewportScroller.scrollToAnchor(fragment);
      }
    });
  }

}