import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';

@Component({
  selector: 'app-administrator-details',
  templateUrl: './administrator-details.component.html',
  styleUrls: ['./administrator-details.component.scss']
})
export class AdministratorDetailsComponent implements OnInit {

  @ViewChild('adminForm') adminForm!: NgForm;

  admin = {
    uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9',
    firstName: 'John',
    surname: 'Doe',
    affiliation: 'XYZ Company',
    country: 'Greece',
    phoneNumber: '2101111234',
    email: 'john@doe.com',
    invitedDate: '10/03/2024 10:23:55',
    onboardedDate: '11/03/2024 12:32:16',
    offboardedDate: 'N/A',
    invitationId: '008b1beb-3b56-4c19-8aa8-7ab23f3143cc'
  };

  affiliations: string[] = ['XYZ Company', 'ABC Corporation', 'DEF Enterprises'];
  countries: string[] = ['Greece', 'USA', 'Canada', 'UK', 'Germany'];

  onSubmit() {
    if (this.adminForm.valid) {
      console.log('Form Submitted', this.admin);
    }
  }

  onDiscard() {
    // Implement discard logic if needed
    console.log('Form Discarded');
  }

  constructor() { }

  ngOnInit() {
  }

}