import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';

@Component({
  selector: 'app-administrator-onboarding',
  templateUrl: './administrator-onboarding.component.html',
  styleUrls: ['./administrator-onboarding.component.scss']
})
export class AdministratorOnboardingComponent implements OnInit {

  @ViewChild('adminForm') adminForm!: NgForm;

  admin = {
    firstName: '',
    surname: '',
    affiliation: '',
    country: '',
    phoneNumber: '',
    email: ''
  };

  affiliations: string[] = ['XYZ Company', 'ABC Corporation', 'DEF Enterprises'];
  countries: string[] = ['Greece', 'USA', 'Canada', 'UK', 'Germany'];

  onSubmit() {
    if (this.adminForm.valid) {
      console.log('Form Submitted', this.admin);
    }
  }

  onDiscard() {
    // Implement discard logic if needed
    console.log('Form Discarded');
  }

  constructor() { }

  ngOnInit() {
  }

}