import {Component, OnInit, ViewChild} from '@angular/core';
import {NgForm} from '@angular/forms';
import {MemberApiService} from "../../../../services/api/member.api.service";
import { MatSnackBar } from '@angular/material/snack-bar';
import { Router } from '@angular/router';
import { of, map } from 'rxjs';


@Component({
  selector: 'app-member-onboarding',
  templateUrl: './member-onboarding.component.html',
  styleUrls: ['./member-onboarding.component.scss']
})
export class MemberOnboardingComponent implements OnInit {
  private defaultDuration: number = 3000;

  constructor(private readonly memberApiService: MemberApiService,private snackBar: MatSnackBar,
    private router: Router
    ) {
  }

  ngOnInit() {
  }

  @ViewChild('memberForm') memberForm!: NgForm;
  member = {
    name: 'Some Federation Authority',
    did: 'did:gktc:2itDAKCERh95uGgKbJNHYP',
    description: 'Desc',
    type: 'AUTHORITY',
    country: 'Italy',
    contactEmail: 'test@test.com'
  };

  types: string[] = ['AUTHORITY', 'DATASPACE'];
  countries: string[] = ['Italy', 'Greece', 'USA', 'Canada', 'UK', 'Germany'];

  onSubmit() {
    if (this.memberForm.valid) {
      console.log('Form Submitted', this.member);
      const data : any = null;
      this.memberApiService.postMember(this.member).pipe(map(data => data.toString));
        //if (data) {
          console.log('Member Created', data);
          this.snackBar.open('Member Created', 'Success', {
            duration: this.defaultDuration,
          });
          this.router.navigate(['/member-list']);
       // }
      };
    }
  

  onDiscard() {
    // Implement discard logic if needed
    console.log('Form Discarded');
  }
}
