import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { MatTableDataSource } from '@angular/material/table';
import { single } from './data';
import {Color, ScaleType} from '@swimlane/ngx-charts';
import { MatPaginator } from '@angular/material/paginator';
import { Router } from '@angular/router';

@Component({
  selector: 'app-trader-details',
  templateUrl: './trader-details.component.html',
  styleUrls: ['./trader-details.component.scss']
})
export class TraderDetailsComponent implements AfterViewInit {

  // @ts-ignore
  single: any[];
  // @ts-ignore
  multi: any[];

  view: [number, number] = [1200, 400];

  // options
  showXAxis = true;
  showYAxis = true;
  gradient = false;
  showLegend = true;
  showXAxisLabel = true;
  xAxisLabel = 'Country';
  showYAxisLabel = true;
  yAxisLabel = 'Value';

  // colorScheme = {
  //   domain: ['#5AA454', '#A10A28', '#C7B42C', '#AAAAAA']
  // };

  // @ts-ignore
  colorScheme: Color = {
    name: 'myScheme',
    selectable: true,
    group: ScaleType.Ordinal, // or ScaleType.Linear
    domain: ['#5AA454', '#A10A28', '#C7B42C', '#AAAAAA', '#3333CC', '#FF6600', '#990099']
  };

  selectedIndicator: string = 'turnover';

  constructor(private router: Router) {
    Object.assign(this, { single })
  }

  // @ts-ignore
  onSelect(event) {
    console.log(event);
  }

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }

  trader = {
    uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9',
    affiliation: 'Some Company',
    totalBalance: 7690.00
  };

  hideInactive: boolean = false;
  displayedColumns: string[] = ['tid', 'balance', 'inTrades', 'outTrades', 'status'];
  dataSource = new MatTableDataSource<TradingAccount>(TRADING_ACCOUNT_DATA);
  totalLength = TRADING_ACCOUNT_DATA.length;

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getStatusClass(status: string): string {
    return status.toLowerCase();
  }

  redirectToPage(): void {
    console.log('Field clicked, redirecting...');
    // this.router.navigate(['/trusted-source-details']);
    window.open('/trusted-source-details', '_blank');
  }
}

export interface TradingAccount {
  tid: string;
  balance: number;
  inTrades: number;
  outTrades: number;
  status: string;
}

const TRADING_ACCOUNT_DATA: TradingAccount[] = [
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 5, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'DISABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'DISABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 5, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'DISABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'DISABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 5, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'ENABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'DISABLED' },
  { tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5', balance: 7690.00, inTrades: 15, outTrades: 0, status: 'DISABLED' },
];