import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';
import {Member} from "../../member/member-list/member-list.component";
import {TraderApiService} from "../../../../services/api/trader.api.service";

@Component({
  selector: 'app-trader-list',
  templateUrl: './trader-list.component.html',
  styleUrls: ['./trader-list.component.scss']
})
export class TraderListComponent implements AfterViewInit {

  constructor(private readonly traderApiService: TraderApiService) {
    this.getData();
  }

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }

  searchQuery: string = '';
  hideInactive: boolean = false;
  displayedColumns: string[] = ['uid', 'affiliation', 'activeAccounts'];
  dataSource = new MatTableDataSource<Trader>();
  totalLength = TRADER_DATA.length;

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getActiveAccountsClass(activeAccounts: number): string {
    return activeAccounts > 0 ? 'greater-than-zero' : 'zero';
  }

  getData(): void {
    this.dataSource = new MatTableDataSource<Trader>(TRADER_DATA);
    this.totalLength = TRADER_DATA.length;
    /* this.traderApiService.listTraders().subscribe((data: any) => {
       if(data && data.length > 0) {
        console.table
        this.dataSource = new MatTableDataSource<Trader>(data);
        this.totalLength = data.length;
      }
      else { 
        this.dataSource = new MatTableDataSource<Trader>(TRADER_DATA);
        this.totalLength = TRADER_DATA.length;
      }
    }); */
  }


}

export interface Trader {
  uid: string;
  affiliation: string;
  activeAccounts: number;
}

const TRADER_DATA: Trader[] = [
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federation Authority', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federation Authority', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 3 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 0 },
  { uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'Some Federated Dataspace', activeAccounts: 3 },
];
