import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-trusted-source-list',
  templateUrl: './trusted-source-list.component.html',
  styleUrls: ['./trusted-source-list.component.scss']
})
export class TrustedSourceListComponent implements AfterViewInit {

  constructor() { }

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }

  searchQuery: string = '';
  selectedSort: string = 'newest';
  hideInactive: boolean = false;
  displayedColumns: string[] = ['legalName', 'pid', 'status'];
  dataSource = new MatTableDataSource<TrustedSource>(TRUSTED_SOURCE_DATA);
  totalLength = TRUSTED_SOURCE_DATA.length;

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  filterData(): void {
    // Implement filtering logic based on hideInactive
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getStatusClass(status: string): string {
    switch (status.toLowerCase()) {
      case 'pending': return 'pending';
      case 'onboarded': return 'onboarded';
      case 'offboarded': return 'offboarded';
      default: return '';
    }
  }

}

export interface TrustedSource {
  legalName: string;
  pid: string;
  status: string;
}

const TRUSTED_SOURCE_DATA: TrustedSource[] = [
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'ONBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
  { legalName: 'XYZ Legal Company', pid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa', status: 'OFFBOARDED' },
];