import { AfterViewInit, Component, ElementRef, HostListener, NgModule, OnInit, ViewChild } from '@angular/core';
import { ComponentList } from 'src/app/components/component-list/component-list.component';

interface Item {
  title: string;
}

@Component({
  selector: 'app-fdac',
  templateUrl: './fdac.component.html',
  styleUrls: ['./fdac.component.scss']
})
export class FdacComponent implements OnInit, AfterViewInit {

  items: Item[] = Array.from({ length: 100 }, (_, i) => ({ title: `AI based detection of fraudulent immediate loan requests ${i + 1}` }));
  paginatedItems: Item[] = [];
  selectedSort = 'newest';  // Default value for Sort by
  selectedPageSize = '18';    // Default value for Items per page (as string)
  currentPage = 0;
  searchQuery = ''; // Search query
  selectedTypes = ['All']; // Default selected types
  types = ['All', 'Datasets', 'Algorithms', 'Software', 'Documentations', 'Tutorials'];
  dateFrom: Date | null = null; // Date from
  dateTo: Date | null = null; // Date to

  dropdownOpen = false;
  selectedOption = 'Newest';
  options = ['Newest', 'Oldest', 'Relevance'];
  componentList: ComponentList | null = null
  dropdownUserOpen = false;
  selectedUserOption = '18';  // Default value for Items per page dropdown
  optionsUser = ['10', '18', '30'];
  @ViewChild("components")
  set appShark(el: ComponentList) {
    this.componentList = el

  };
  constructor() {
    //@ts-ignore
    window.fdac = this
  }

  set pane(v: HTMLIFrameElement) {

  }

  ngOnInit(): void {
    this.updatePaginatedItems();
  }

  ngAfterViewInit() { }

  toggleDropdown() {
    this.dropdownOpen = !this.dropdownOpen;
  }

  selectOption(option: string) {
    this.selectedOption = option;
    this.dropdownOpen = false;
  }
  onChange(ev: any) {
    this.componentList?.iframe?.sendMessage({ action: "search", value: ev.target.value })
  }
  toggleUserDropdown() {
    this.dropdownUserOpen = !this.dropdownUserOpen;
  }

  selectUserOption(option: string) {
    this.selectedUserOption = option;
    this.onPageSizeChange(option);
    this.dropdownUserOpen = false;
  }

  @HostListener('document:click', ['$event'])
  handleDocumentClick(event: Event) {
    const target = event.target as HTMLElement;
    const clickedInsideSort = target.closest('.dropdown.sort');
    const clickedInsideUser = target.closest('.dropdown.user');

    if (!clickedInsideSort) {
      this.dropdownOpen = false;
    }

    if (!clickedInsideUser) {
      this.dropdownUserOpen = false;
    }
  }

  updatePaginatedItems() {
    const pageSize = parseInt(this.selectedPageSize, 10); // Convert to number
    const startIndex = this.currentPage * pageSize;
    const endIndex = startIndex + pageSize;
    this.paginatedItems = this.items.slice(startIndex, endIndex);
  }

  onPageSizeChange(newSize: string) {
    this.selectedPageSize = newSize;
    this.currentPage = 0; // Reset to first page
    this.updatePaginatedItems();
  }

  onPageChange(event: any) {
    this.currentPage = event.pageIndex;
    this.updatePaginatedItems();
  }

  onTypeChange(selectedTypes: string[]) {
    const allCombinations = [
      ['Datasets', 'Algorithms', 'Software'],
      ['Datasets', 'Algorithms'],
      ['Documentations', 'Tutorials'],
      ['Datasets', 'Algorithms', 'Software', 'Documentations'],
      ['Datasets', 'Algorithms', 'Software', 'Tutorials'],
      ['Datasets', 'Algorithms', 'Documentations'],
      ['Datasets', 'Algorithms', 'Documentations', 'Tutorials'],
      ['Datasets', 'Algorithms', 'Tutorials'],
      ['Datasets', 'Software'],
      ['Datasets', 'Software', 'Documentations'],
      ['Datasets', 'Software', 'Documentations', 'Tutorials'],
      ['Datasets', 'Software', 'Tutorials'],
      ['Datasets', 'Documentations'],
      ['Datasets', 'Documentations', 'Tutorials'],
      ['Datasets', 'Tutorials'],
      ['Algorithms', 'Software'],
      ['Algorithms', 'Software', 'Documentations'],
      ['Algorithms', 'Software', 'Documentations', 'Tutorials'],
      ['Algorithms', 'Software', 'Tutorials'],
      ['Algorithms', 'Documentations'],
      ['Algorithms', 'Documentations', 'Tutorials'],
      ['Algorithms', 'Tutorials'],
      ['Software', 'Documentations'],
      ['Software', 'Documentations', 'Tutorials'],
      ['Software', 'Tutorials'],
      ['Documentations', 'Tutorials']

    ];

    const setSelectedTypes = (types: string[]) => {
      this.selectedTypes = types;
      console.log(this.selectedTypes);
    };

    const shouldSelectAll = (types: string[]): boolean => {
      return allCombinations.some(combination =>
        combination.every(type => types.includes(type)) &&
        combination.length === types.length
      );
    };

    if (selectedTypes.includes('All') && selectedTypes.length > 1) {
      const filteredTypes = selectedTypes.filter(type => type !== 'All');
      if (shouldSelectAll(filteredTypes)) {
        setSelectedTypes(['All']);
      } else {
        setSelectedTypes(filteredTypes);
      }
      console.log(this.selectedTypes + "1");
    } else if (selectedTypes.length === 0) {
      setSelectedTypes(['All']);
      console.log(this.selectedTypes + "2");
    } else {
      setSelectedTypes(selectedTypes);
      console.log(this.selectedTypes + "3");
    }
  }



  resetFilters() {
    this.searchQuery = '';
    this.selectedTypes = ['All'];
    this.dateFrom = null;
    this.dateTo = null;
    this.selectedSort = 'newest';
    this.selectedPageSize = '18';
    this.currentPage = 0;
    this.updatePaginatedItems();
  }
}