import { AfterViewInit, Component, HostListener, OnInit } from '@angular/core';

interface Item {
  title: string;
}

@Component({
  selector: 'app-learning-centre',
  templateUrl: './learning-centre.component.html',
  styleUrls: ['./learning-centre.component.scss']
})
export class LearningCentreComponent implements OnInit, AfterViewInit {
  items: Item[] = Array.from({ length: 100 }, (_, i) => ({ title: `AI based detection of fraudulent immediate loan requests ${i + 1}` }));
  paginatedItems: Item[] = [];
  selectedSort = 'newest';  // Default value for Sort by
  selectedPageSize = '18';  // Default value for Items per page
  currentPage = 0;
  searchQuery = ''; // Search query
  selectedTypes = ['All']; // Default selected types
  types = ['All', 'Courses', 'How-to guides', 'Webinars', 'Hands-on examples', 'Publications', 'External Resources'];
  dateFrom: Date | null = null; // Date from
  dateTo: Date | null = null; // Date to

  dropdownOpen = false;
  selectedOption = 'Newest';
  options = ['Newest', 'Oldest', 'Relevance'];

  dropdownUserOpen = false;
  selectedUserOption = '18';  // Default value for Items per page dropdown
  optionsUser = ['10', '18', '30'];  

  constructor() { }

  ngOnInit(): void {
    this.updatePaginatedItems();
  }

  ngAfterViewInit() {}

  toggleDropdown() {
    this.dropdownOpen = !this.dropdownOpen;
  }

  selectOption(option: string) {
    this.selectedOption = option;
    this.dropdownOpen = false;
  }

  toggleUserDropdown() {
    this.dropdownUserOpen = !this.dropdownUserOpen;
  }

  selectUserOption(option: string) {
    this.selectedUserOption = option;
    this.onPageSizeChange(option);
    this.dropdownUserOpen = false;
  }

  @HostListener('document:click', ['$event'])
  handleDocumentClick(event: Event) {
    const target = event.target as HTMLElement;
    const clickedInsideSort = target.closest('.dropdown.sort');
    const clickedInsideUser = target.closest('.dropdown.user');

    if (!clickedInsideSort) {
      this.dropdownOpen = false;
    }

    if (!clickedInsideUser) {
      this.dropdownUserOpen = false;
    }
  }

  updatePaginatedItems() {
    const pageSize = parseInt(this.selectedPageSize, 10); // Convert to number
    const startIndex = this.currentPage * pageSize;
    const endIndex = startIndex + pageSize;
    this.paginatedItems = this.items.slice(startIndex, endIndex);
  }

  onPageSizeChange(newSize: string) {
    this.selectedPageSize = newSize;
    this.currentPage = 0; // Reset to first page
    this.updatePaginatedItems();
  }

  onPageChange(event: any) {
    this.currentPage = event.pageIndex;
    this.updatePaginatedItems();
  }

  onTypeChange(selectedTypes: string[]) {
    const allCombinations = [
        ['Courses', 'How-to guides', 'Webinars'],
        ['Courses', 'How-to guides'],
        ['Courses', 'Hands-on examples'],
        ['Courses', 'Publications'],
        ['Courses', 'External Resources'],
        ['How-to guides', 'Webinars'],
        ['How-to guides', 'Hands-on examples'],
        ['How-to guides', 'Publications'],
        ['How-to guides', 'External Resources'],
        ['Webinars', 'Hands-on examples'],
        ['Webinars', 'Publications'],
        ['Webinars', 'External Resources'],
        ['Hands-on examples', 'Publications'],
        ['Hands-on examples', 'External Resources'],
        ['Publications', 'External Resources'],
        ['Courses', 'How-to guides', 'Webinars', 'Hands-on examples'],
        ['Courses', 'How-to guides', 'Webinars', 'Publications'],
        ['Courses', 'How-to guides', 'Webinars', 'External Resources'],
        ['Courses', 'How-to guides', 'Hands-on examples', 'Publications'],
        ['Courses', 'How-to guides', 'Hands-on examples', 'External Resources'],
        ['Courses', 'How-to guides', 'Publications', 'External Resources'],
        ['Courses', 'Webinars', 'Hands-on examples', 'Publications'],
        ['Courses', 'Webinars', 'Hands-on examples', 'External Resources'],
        ['Courses', 'Webinars', 'Publications', 'External Resources'],
        ['Courses', 'Hands-on examples', 'Publications', 'External Resources'],
        ['How-to guides', 'Webinars', 'Hands-on examples', 'Publications'],
        ['How-to guides', 'Webinars', 'Hands-on examples', 'External Resources'],
        ['How-to guides', 'Webinars', 'Publications', 'External Resources'],
        ['How-to guides', 'Hands-on examples', 'Publications', 'External Resources'],
        ['Webinars', 'Hands-on examples', 'Publications', 'External Resources'],
        ['Courses', 'How-to guides', 'Webinars', 'Hands-on examples', 'Publications'],
        ['Courses', 'How-to guides', 'Webinars', 'Hands-on examples', 'External Resources'],
        ['Courses', 'How-to guides', 'Webinars', 'Publications', 'External Resources'],
        ['Courses', 'How-to guides', 'Hands-on examples', 'Publications', 'External Resources'],
        ['Courses', 'Webinars', 'Hands-on examples', 'Publications', 'External Resources'],
        ['How-to guides', 'Webinars', 'Hands-on examples', 'Publications', 'External Resources'],
        ['Courses', 'How-to guides', 'Webinars', 'Hands-on examples', 'Publications', 'External Resources']
    ];

    const setSelectedTypes = (types: string[]) => {
        this.selectedTypes = types;
        console.log(this.selectedTypes);
    };

    const shouldSelectAll = (types: string[]): boolean => {
        return allCombinations.some(combination => 
            combination.every(type => types.includes(type)) &&
            combination.length === types.length
        );
    };

    if (selectedTypes.includes('All') && selectedTypes.length > 1) {
        const filteredTypes = selectedTypes.filter(type => type !== 'All');
        if (shouldSelectAll(filteredTypes)) {
            setSelectedTypes(['All']);
        } else {
            setSelectedTypes(filteredTypes);
        }
        console.log(this.selectedTypes + "1");
    } else if (selectedTypes.length === 0) {
        setSelectedTypes(['All']);
        console.log(this.selectedTypes + "2");
    } else {
        setSelectedTypes(selectedTypes);
        console.log(this.selectedTypes + "3");
    }
}


  resetFilters() {
    this.searchQuery = '';
    this.selectedTypes = ['All'];
    this.dateFrom = null;
    this.dateTo = null;
    this.selectedSort = 'newest';
    this.selectedPageSize = '18';
    this.selectedUserOption = '18';  // Reset the selectedUserOption as well
    this.currentPage = 0;
    this.updatePaginatedItems();
  }

  applyFilters() {
    // Handle filter application logic here
  }
}