import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'app-profile-page-account',
  templateUrl: './profile-page-account.component.html',
  styleUrls: ['./profile-page-account.component.scss']
})
export class ProfilePageAccountComponent implements OnInit {

  accounts = [
    {
      id: '0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73',
      title: 'Account #1',
      name: 'John',
      surname: 'Doe',
      dateOfOnboarding: '25/03/2024',
      authorizationParty: 'Multi-party authorization',
      balance: '100.99',
      open: true
    },
    {
      id: '0xFE3B557E8Fb62b89F4916B721be55cEb828dBd73',
      title: 'Account #2',
      name: 'Jane',
      surname: 'Smith',
      dateOfOnboarding: '10/01/2024',
      authorizationParty: 'Single-party authorization',
      balance: '200.00',
      open: false
    }
  ];

  constructor() { }

  ngOnInit() {
  }

  toggleAccount(index: number) {
    this.accounts[index].open = !this.accounts[index].open;
  }
}
