import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'app-profile-page-asset',
  templateUrl: './profile-page-asset.component.html',
  styleUrls: ['./profile-page-asset.component.scss']
})
export class ProfilePageAssetComponent implements OnInit {

  assets = [
    {
      title: 'FAME Data Marketplace - Asset 1',
      description: 'Asset 1 - Description',
      type: 'Dataset',
      rating: 4.25,
      reviews: 2,
      views: 50,
      updated: '2 months ago'
    },
    {
      title: 'FAME Data Marketplace - Asset 2',
      description: 'Asset 2 - Description',
      type: 'Policy',
      rating: 4.25,
      reviews: 4,
      views: 70,
      updated: '3 months ago'
    }
  ];

  filters = [
    { label: 'All', selected: true },
    { label: 'Tools', selected: false },
    { label: 'Policies', selected: false },
    { label: 'Datasets', selected: false },
    { label: 'Webinars', selected: false },
    { label: 'Tutorials', selected: false }
  ];

  selectFilter(selectedFilter: any) {
    this.filters.forEach(filter => filter.selected = false);
    selectedFilter.selected = true;
  }

  constructor() { }

  ngOnInit() {
  }

}