import { Component, OnDestroy, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { AdvancedSearchService } from 'src/app/services/advanced-search.service';

@Component({
  selector: 'app-search-page',
  templateUrl: './search-page.component.html',
  styleUrls: ['./search-page.component.scss']
})
export class SearchPageComponent implements OnInit, OnDestroy  {
  query: string = '';
  priceRange: number[] = [10, 400];
  selectedSubscription: any = { name: 'True' };
  subscriptionOptions: any[] = [
    { name: 'Complete' },
    { name: 'Partial' }
  ];
  selectedOutput: any = { name: 'Components' };
  outputFilters: any[] = [
    { name: 'Components' },
    { name: 'All' }
  ];
  businessModels: any[] = [
    { name: 'Complete' },
    { name: 'Partial' }
  ];
  publisher: string = '';
  selectedAsset: any = null;
  assetTypes: any[] = [
    { name: 'Algorithm' },
    { name: 'Model' },
    { name: 'Interface' },
    { name: 'Service' }
  ];
  showFilters: boolean = true; // Set to true initially
  response: any = null;
  loading: boolean = false;

  constructor(
    private advancedSearchService: AdvancedSearchService,
    private route: ActivatedRoute,
    private router: Router
  ) { }

  ngOnInit() {
    this.route.queryParams.subscribe(params => {
      this.query = params['query'] || '';
      if (this.query) {
        this.search(); // Automatically call search if query is present
      } else {
        this.clearSearch(); // Clear search input and results if no query
      }
    });
  }
  
  clearSearch() {
    this.query = '';
    this.response = null;
  }

  ngOnDestroy() {
    // Clear query parameter and results when component is destroyed
    this.router.navigate([], {
      queryParams: { query: null },
      queryParamsHandling: 'merge'
    });
    this.query = '';
    this.response = null;
  }

  toggleFilters() {
    this.showFilters = !this.showFilters;
  }

  search() {
    const filters = [];

    if (this.selectedAsset && this.selectedAsset.name) {
      filters.push({
        values: [this.selectedAsset.name],
        type: 'tag'
      });
    }

    if (this.publisher) {
      filters.push({
        values: [this.publisher],
        type: 'developer'
      });
    }

    const data = {
      expand: true,
      outputFilter: [this.selectedOutput.name],
      values: [{
        term: this.query,
        filters: filters
      }]
    };

    this.loading = true;
    this.advancedSearchService.query(data).subscribe({
      next: (response) => {
        this.response = response;
        console.log(this.response);
        this.loading = false;
      },
      error: (error) => {
        console.error('Error fetching data:', error);
        this.loading = false;
      }
    });
  }
}
