import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, map } from 'rxjs/operators';

@Injectable({
  providedIn: 'root'
})
export class AdvancedSearchService {
  private apiClient;
  private baseURL = 'https://fame-fdac.iot-catalogue.com';

  constructor(private http: HttpClient) {
    this.apiClient = {
      baseURL: this.baseURL,
      headers: new HttpHeaders({
        'Content-Type': 'application/json',
        'accept': 'application/json',
        'Authorization': 'Bearer FlIsbBwtJFrBzNUzrQz01_fgPvnJ-2K4EdzlloiBukg'
      })
    };
  }

  /**
   * Perform a query to the backend API to search for data.
   *
   * @param {Object} data - The data to be sent in the query
   * @returns {Observable<Object>} - An observable that resolves with the data from the response
   * @throws {Error} - If an error occurs during the query
   */
  query(data: any): Observable<any> {
    const url = `${this.apiClient.baseURL}/api/data/search`;

    // Log the request details
    console.log('Making request to:', url);
    console.log('Request headers:', this.apiClient.headers);
    console.log('Request payload:', data);

    return this.http.post<any>(url, data, { headers: this.apiClient.headers })
      .pipe(
        map(response => response.results),
        catchError(error => {
          console.error('Error fetching data:', error);
          return throwError(error);
        })
      );
  }
}
