import { Injectable } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { filter } from 'rxjs/operators';
import {HttpClient} from "@angular/common/http";
import {environment} from "../../../environments/environment";

@Injectable({
  providedIn: 'root',
})
export class MemberApiService {

  private url = environment.govUrl + 'members';
  constructor(private httpClient: HttpClient) {
  }


  listMembers() {
    return this.httpClient.get(this.url);
  }


  postMember(member: any) {
    const inputMember = {
      did: member.did,
      cty: member.country?.substring(0, 2).toUpperCase(), // TODO convert country to country code
      name: member.name,
      email: member.contactEmail,
      typ: member.type,
      desc: member.description,
    };
    return this.httpClient.post(this.url, inputMember);
  }
}
