import { Injectable } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { filter } from 'rxjs/operators';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { environment } from '../../../environments/environment';

@Injectable({
  providedIn: 'root',
})
export class PatApiService {
  private url = environment.patUrl;
  constructor(private httpClient: HttpClient) {}

  public retrieveQuestions(request: any) {
    let headers = new HttpHeaders();
    headers = headers.set('Accept', 'application/json');
    return this.httpClient.get(
      this.url +
        'pricing-params?base58=' +
        //encodeURIComponent(JSON.stringify(request)),
        request,
      { headers: headers }
    );
  }

  public calculatePrice(questionnaireCompiled: any) {
    let headers = new HttpHeaders();
    headers = headers.set('Accept', 'application/json');
    return this.httpClient.get(
      this.url +
        'pricing-advice?base58=' +
        // encodeURIComponent(JSON.stringify(questionnaireCompiled)),
        questionnaireCompiled,
      { headers: headers }
    );
  }
  // TODO
  public retrieveQuestionsMock() {
    return (
      '{\n' +
      '    "cid": "FAME-DATASET-QUESTIONS-V2", \n' +
      '    "questions": [ \n' +
      '        {  \n' +
      '            "id": 1, \n' +
      '            "group": 1, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "What is the minimum price for the asset required by the seller ?", \n' +
      '            "type": "DECIMAL", \n' +
      '            "limits": { \n' +
      '                "min": 30    \n' +
      '            }  \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 2, \n' +
      '            "group": 1, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "What is the price of a comparable asset traded in the FAME ?", \n' +
      '            "type": "DECIMAL", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 3, \n' +
      '            "group": 1, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "How reliabilite are the information in the asset?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                { \n' +
      '                    "label": "not reliable", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "some reliable", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "nearly reliable", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "very reliable", \n' +
      '                    "value": 5 \n' +
      '                } \n' +
      '            ] \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 4, \n' +
      '            "group": 1, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "Is the asset usable for long term purposes?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 5, \n' +
      '            "group": 1, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "How suitable are data in the asset for a wide range of analyses and interpretations?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                { \n' +
      '                    "label": "one interpretation only", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "some interpretations/analyses", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "more interpretations/analyses", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "universal", \n' +
      '                    "value": 5 \n' +
      '                } \n' +
      '            ] \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 6, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "How accurate are the information in the asset?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                {\n' +
      '                    "label": "not accurate", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "some accurate", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "nearly accurate", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "very accurate", \n' +
      '                    "value": 5 \n' +
      '                } \n' +
      '            ] \n' +
      '        }, \n' +
      '        {  \n' +
      '            "id": 7, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "Are the information in the asset historical?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 8, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "What is the age of the dataset (in months) ?", \n' +
      '            "type": "INTEGER", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 9, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "Are the data normalized, standardized or adjusted before input?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 10, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "Are information in this asset anonymized?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 11, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "Are information in this asset secured?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 12, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "How credible is the source of the asset?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                { \n' +
      '                    "label": "not credible at all", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "has some credibility", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "nearly credible", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "verified", \n' +
      '                    "value": 5 \n' +
      '                }\n' +
      '            ] \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 13, \n' +
      '            "group": 2, \n' +
      '            "required": true, \n' +
      '            "weight": 0.125, \n' +
      '            "label": "Have these data been validated against independent sources or standards?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        {  \n' +
      '            "id": 14, \n' +
      '            "group": 3, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "Are the units in which the data were collected clearly defined?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 15, \n' +
      '            "group": 3, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "How many rows does the asset contain?", \n' +
      '            "type": "INTEGER", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 16, \n' +
      '            "group": 3, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "How many columns does the asset contain?", \n' +
      '            "type": "INTEGER", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 17, \n' +
      '            "group": 3, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "Are there any missing information in the asset?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 18, \n' +
      '            "group": 3, \n' +
      '            "required": true, \n' +
      '            "weight": 0.2, \n' +
      '            "label": "Is dataset clearly described (dictionary/metadata)?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 19, \n' +
      '            "group": 4, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "How difficult is to adapt tools and systems to work with this data?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                {\n' +
      '                    "label": "not difficult at all", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "some difficult", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "more difficult", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "very difficult", \n' +
      '                    "value": 5 \n' +
      '                } \n' +
      '            ] \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 20, \n' +
      '            "group": 4, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "Is it necessary to use additional software to manage/read/update the data?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 21, \n' +
      '            "group": 4, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "Are additional costs required to potentially correct or remedy inconsistencies in the data?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        {\n' +
      '            "id": 22, \n' +
      '            "group": 4, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "How much has been invested in quality control and verification of this data (in Man-day)?", \n' +
      '            "type": "DECIMAL", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 23, \n' +
      '            "group": 5, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "Are the data in the asset cleaned?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 24, \n' +
      '            "group": 5, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "Are the data in the asset processed?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        {\n' +
      '            "id": 25, \n' +
      '            "group": 5, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "Are there any metadata or information about the origin and processing of the data in asset?", \n' +
      '            "type": "BOOLEAN"\n' +
      '        }, \n' +
      '        {\n' +
      '            "id": 26, \n' +
      '            "group": 5, \n' +
      '            "required": true, \n' +
      '            "weight": 0.25, \n' +
      '            "label": "Are the data graphically processed?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 27, \n' +
      '            "group": 6, \n' +
      '            "required": true, \n' +
      '            "weight": 0.5, \n' +
      '            "label": "Are the data processed from another source?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 28, \n' +
      '            "group": 6, \n' +
      '            "required": true, \n' +
      '            "weight": 0.5, \n' +
      '            "label": "How much are the offered asset market exclusive?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                {\n' +
      '                    "label": "generic", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "some", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "limited", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "unique", \n' +
      '                    "value": 5 \n' +
      '                } \n' +
      '            ] \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 29, \n' +
      '            "group": 7, \n' +
      '            "required": true, \n' +
      '            "weight": 0.33333333333, \n' +
      '            "label": "How difficult is to search for and obtain the offered information in asset?", \n' +
      '            "type": "SELECT", \n' +
      '            "options": [ \n' +
      '                { \n' +
      '                    "label": "not difficult at all", \n' +
      '                    "value": 1 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "some difficult", \n' +
      '                    "value": 2 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "average", \n' +
      '                    "value": 3 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "more difficult", \n' +
      '                    "value": 4 \n' +
      '                }, \n' +
      '                { \n' +
      '                    "label": "very difficult", \n' +
      '                    "value": 5 \n' +
      '                } \n' +
      '            ] \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 30, \n' +
      '            "group": 7, \n' +
      '            "required": true, \n' +
      '            "weight": 0.33333333333, \n' +
      '            "label": "How much time were required to assemble and prepare the asset in question (in months)?", \n' +
      '            "type": "INTEGER", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 31, \n' +
      '            "group": 7, \n' +
      '            "required": true, \n' +
      '            "weight": 0.33333333333, \n' +
      '            "label": "How much resources were required to assemble and prepare the asset in question (in Man-day)?", \n' +
      '            "type": "DECIMAL", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 32, \n' +
      '            "group": 8, \n' +
      '            "required": true, \n' +
      '            "weight": 1, \n' +
      '            "label": "How much capacity space is needed to store this data (in GB)?", \n' +
      '            "type": "DECIMAL", \n' +
      '            "limits": { \n' +
      '                "min": 0 \n' +
      '            } \n' +
      '        }, \n' +
      '        { \n' +
      '            "id": 33, \n' +
      '            "group": 9, \n' +
      '            "required": true, \n' +
      '            "weight": 1, \n' +
      '            "label": "Are the data processed from another source?", \n' +
      '            "type": "BOOLEAN" \n' +
      '        } \n' +
      '    ] \n' +
      '}'
    );
  }

  public retrieveQuestionsMock2() {
    return (
      '{\n' +
      '  "cid": "FAME-DATASET-QUESTIONS-V3",\n' +
      '  "questions": [\n' +
      '    {\n' +
      '      "id": 1,\n' +
      '      "group": 1,\n' +
      '      "required": true,\n' +
      '      "weight": 0.2,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "Will the information in the asset regularly updated ?",\n' +
      '      "type": "BOOLEAN"\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 2,\n' +
      '      "group": 1,\n' +
      '      "required": true,\n' +
      '      "weight": 0.2,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "How suitable are data in the asset for a wide range of analyses and interpretations?",\n' +
      '      "type": "SELECT",\n' +
      '      "options": [\n' +
      '        {\n' +
      '          "label": "one interpretation only",\n' +
      '          "value": 1\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "some interpretations/analyses",\n' +
      '          "value": 2\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "average suitable",\n' +
      '          "value": 3\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "more interpretations/analyses",\n' +
      '          "value": 4\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "universal",\n' +
      '          "value": 5\n' +
      '        }\n' +
      '      ]\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 3,\n' +
      '      "group": 1,\n' +
      '      "required": true,\n' +
      '      "weight": 0.2,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "Is it necessary to clean the data (redudancy, errors, typo...) ?",\n' +
      '      "type": "BOOLEAN"\n' +
      '          },\n' +
      '    {\n' +
      '      "id": 4,\n' +
      '      "group": 1,\n' +
      '      "required": true,\n' +
      '      "weight": 0.2,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "limits": {\n' +
      '        "min": 0,\n' +
      '        "max": 12\n' +
      '      },\n' +
      '      "label": "How old is the information in the dataset (months) ?",\n' +
      '      "type": "INTEGER"\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 5,\n' +
      '      "group": 1,\n' +
      '      "required": true,\n' +
      '      "weight": 0.2,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "limits": {\n' +
      '        "min": 0,\n' +
      '        "max": 12\n' +
      '      },\n' +
      '      "label": "When was dataset created/compiled (months) ?",\n' +
      '      "type": "INTEGER"\n' +
      '    }\n' +
      /*
      '    {\n' +
      '      "id": 6,\n' +
      '      "group": 2,\n' +
      '      "required": true,\n' +
      '      "weight": 0.125,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "Are the data in the dataset manipuleted (adjusted) in any way?",\n' +
      '      "type": "BOOLEAN"\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 7,\n' +
      '      "group": 2,\n' +
      '      "required": true,\n' +
      '      "weight": 0.125,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "Does dataset contain unique identifier so that it can be connected to other available datasets?",\n' +
      '      "type": "BOOLEAN"\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 8,\n' +
      '      "group": 2,\n' +
      '      "required": true,\n' +
      '      "weight": 0.125,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "How credible is the source of the asset?",\n' +
      '      "type": "SELECT",\n' +
      '      "options": [\n' +
      '        {\n' +
      '          "label": "not credible at all",\n' +
      '          "value": 1\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "has some credibility",\n' +
      '          "value": 2\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "average",\n' +
      '          "value": 3\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "nearly credible",\n' +
      '          "value": 4\n' +
      '        },\n' +
      '        {\n' +
      '          "label": "verified",\n' +
      '          "value": 5\n' +
      '        }\n' +
      '      ]\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 9,\n' +
      '      "group": 2,\n' +
      '      "required": true,\n' +
      '      "weight": 0.125,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "label": "Have these data been validated against independent sources or standards?",\n' +
      '      "type": "BOOLEAN"\n' +
      '    },\n' +
      '    {\n' +
      '      "id": 10,\n' +
      '      "group": 2,\n' +
      '      "required": true,\n' +
      '      "weight": 0.125,\n' +
      '      "assetType" : "DATASET",\n' +
      '      "limits": {\n' +
      '        "min": 0,\n' +
      '        "max": 100\n' +
      '      },\n' +
      '      "label": "How many information points doeas the asset contain?",\n' +
      '      "type": "INTEGER"\n' +
      '    }\n' + */
      '  ]\n' +
      '}'
    );
  }
}
