import { Injectable } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { filter } from 'rxjs/operators';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../../environments/environment';

@Injectable({
  providedIn: 'root',
})
export class ProvenanceApiService {
  private govUrl = environment.govUrl + '/submissions/';
  private assetUrl = environment.ptUrl + 'api/v1.0/submissions/assets/';
  private offeringUrl = environment.ptUrl + 'api/v1.0/submissions/offerings/';
  constructor(private httpClient: HttpClient) {}

  public submitAsset(asset: any) {
    console.log('submitAsset ' + JSON.stringify(asset));
    return this.httpClient.post(this.assetUrl, asset);
  }

  public submitOffering(offeringSubmit: any) {
    console.log('submitOffering ' + JSON.stringify(offeringSubmit));
    return this.httpClient.post(this.offeringUrl, offeringSubmit, {
      responseType: 'text',
    });
  }

  public confirmOffering(offeringId: string) {
    //TODO Remove this call should be done by TM MODULE
    return this.httpClient.put(
      environment.ptiUrl + 'pt/v1.0/offerings/' + offeringId + '/confirm', {}
    );
  }

  public getOfferingDetails(offeringId: string) {
    return this.httpClient.get(
      environment.ptUrl + 'pt/v1.0/offerings-active/' + offeringId
    );
  }

  public checkRequestStatus(requestId: string) {
    return this.httpClient.get(this.govUrl + requestId);
  }
}
