import { Injectable } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { filter } from 'rxjs/operators';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../../environments/environment';
import { off } from 'process';

@Injectable({
  providedIn: 'root',
})
export class TmApiService {
  private tmUrl = environment.tmUrl + '/submissions/';
  constructor(private httpClient: HttpClient) {}

  public purchase(offeringId: any) {
    return this.httpClient.post(this.tmUrl + 'order', {
      oid: offeringId,
    });
  }
}
