import { Injectable } from '@angular/core';
import { ethers } from 'ethers';
import Web3 from 'web3';

@Injectable({
  providedIn: 'root',
})
export class MetamaskChainService {
  constructor() {}

  private abiProvenance =
    '[{"inputs":[],"stateMutability":"nonpayable","type":"constructor"},{"anonymous":false,"inputs":[{"indexed":false,"internalType":"string","name":"PID","type":"string"},{"indexed":false,"internalType":"string","name":"actionType","type":"string"},{"indexed":true,"internalType":"address","name":"executor","type":"address"},{"indexed":false,"internalType":"uint256","name":"created","type":"uint256"}],"name":"Action","type":"event"},{"inputs":[],"name":"owner","outputs":[{"internalType":"address","name":"","type":"address"}],"stateMutability":"view","type":"function","constant":true},{"inputs":[{"internalType":"string","name":"pid","type":"string"},{"internalType":"string","name":"contactinfo","type":"string"}],"name":"registerSource","outputs":[{"internalType":"string","name":"","type":"string"}],"stateMutability":"nonpayable","type":"function"},{"inputs":[{"internalType":"string","name":"pid","type":"string"},{"internalType":"address","name":"tid","type":"address"}],"name":"enableAccount","outputs":[{"internalType":"bool","name":"","type":"bool"}],"stateMutability":"nonpayable","type":"function"},{"inputs":[{"internalType":"string","name":"pid","type":"string"}],"name":"lookupSource","outputs":[{"components":[{"internalType":"string","name":"PID","type":"string"},{"internalType":"address","name":"TID","type":"address"},{"internalType":"string","name":"contactInfo","type":"string"},{"internalType":"string","name":"pbkey","type":"string"},{"internalType":"uint256","name":"created","type":"uint256"}],"internalType":"struct Provenance.ProvStruct","name":"","type":"tuple"}],"stateMutability":"view","type":"function","constant":true},{"inputs":[{"internalType":"address","name":"tid","type":"address"}],"name":"lookupAccount","outputs":[{"internalType":"string","name":"","type":"string"}],"stateMutability":"view","type":"function","constant":true}]';
  
    private contractAddressProvenance =
    '0xe135783649BfA7c9c4c6F8E528C7f56166efC8a6';
  async postAsset(assetParams: any, account: string) {
    let web3 = new Web3();
    // network.address = web3.utils.toChecksumAddress(network.address);
    try {
      // @ts-ignore
      if (typeof window.ethereum !== 'undefined') {
        // @ts-ignore
        web3 = new Web3(window.ethereum);
      } else {
        console.error('Web3 is not available.');
      }
      const contract = new web3.eth.Contract(
        JSON.parse(assetParams.abi) as any,
        assetParams.contractAddress
      );
      const gasPrice = await web3.eth.getGasPrice();
      assetParams.gasPrice = web3.utils.toHex(gasPrice);
      console.log('gas price ' + assetParams.gasPrice);
      const functionGasFees = await (contract.methods as any)
        .postAsset(
          assetParams.assetHash,
          assetParams.aid,
          assetParams.pid,
          assetParams.senderAddress
        )
        .estimateGas({
          from: account,
        });
      console.log('from > ' + account);
      console.log('gasPrice > ' + gasPrice);
      console.log('gas > ' + web3.utils.toHex(functionGasFees));
      const result = await (contract.methods as any)
        .postAsset(
          assetParams.assetHash,
          assetParams.aid,
          assetParams.pid,
          assetParams.senderAddress
        )
        .send({
          from: account,
          gasPrice: web3.utils.toHex(gasPrice),
          gas: web3.utils.toHex(functionGasFees),
        });
      console.log(result);
      return result;
    } catch (error) {
      console.error(error);
      throw new Error('Error when interacting with MetaMask contract');
    }
  }

  async submitPurchase(transaction: any) {
    let signer;
    transaction.gasLimit = ethers.utils.hexlify(ethers.BigNumber.from(1000000));
    try {
      // @ts-ignore
      if (typeof window.ethereum !== 'undefined') {
        // @ts-ignore
        const provider = new ethers.providers.Web3Provider(window.ethereum);
        signer = provider.getSigner();
      } else {
        console.error('Ethers is not available.');
        return;
      }
      const txResponse = await signer.sendTransaction(transaction);
      console.log('Transaction Response:', txResponse);
      const receipt = await txResponse.wait();
      console.log('Transaction Receipt:', receipt);
      return receipt;
    } catch (error) {
      console.error(error);
      alert('Error when interacting with MetaMask contract');
      return error;
    }
  }

  async submitPurchaseMock(account: string) {
    //USE Provenance contract to register the source
    // Only for mock purposes
    const pid = crypto.randomUUID();
    const contactInfo = 'contactInfo';
    let web3 = new Web3();
    // network.address = web3.utils.toChecksumAddress(network.address);
    try {
      // @ts-ignore
      if (typeof window.ethereum !== 'undefined') {
        // @ts-ignore
        web3 = new Web3(window.ethereum);
      } else {
        console.error('Web3 is not available.');
      }
      const contract = new web3.eth.Contract(
        JSON.parse(this.abiProvenance) as any,
        this.contractAddressProvenance
      );
      const gasPrice = await web3.eth.getGasPrice();
      const gasPrice_ = web3.utils.toHex(gasPrice);
      console.log('gas price ' + gasPrice_);
      const functionGasFees = await (contract.methods as any)
        .registerSource(pid, contactInfo)
        .estimateGas({
          from: account,
        });
      console.log('from > ' + account);
      console.log('gasPrice > ' + gasPrice);
      console.log('gas > ' + web3.utils.toHex(functionGasFees));
      const result = await (contract.methods as any)
        .registerSource(pid, contactInfo)
        .send({
          from: account,
          gasPrice: web3.utils.toHex(gasPrice),
          gas: web3.utils.toHex(functionGasFees),
        });
      console.log(result);
      return result;
    } catch (error) {
      console.error(error);
      throw new Error('Error when interacting with MetaMask contract');
    }
  }
}
