import { Injectable } from '@angular/core';
// export const IOT_CAT_URL = "https://www.iot-catalogue.com"
export const IOT_CAT_URL = "https://fame-fdac.iot-catalogue.com"
export const IOT_CAT_TOKEN = "AsKM4XXPihh_yaHRZDdVRxv4orVBReomm3ykAo1IID2"
export const IOT_CAT_CONTEXT = "fame fdac"


export interface IframeRequest {
    "id": string,
    "json": any
}


export interface IframeProps {
    path: string,
    requests?: IframeRequest[]
}

export interface ElementIdInfo {
    _id: string,
    lastUpdate: string,
    _lastUpdateTimestamp: number
}


@Injectable({
    providedIn: 'root',
})
export class IoTCatService {
    baseURL = IOT_CAT_URL
    token = IOT_CAT_TOKEN

    #getHeaders(): Headers {
        const myHeaders = new Headers();
        myHeaders.append("Authorization", `Bearer ${this.token}`);
        myHeaders.append("Content-Type", "application/json");
        return myHeaders
    }


    async getIframeURL({ path, requests }: IframeProps): Promise<string> {
        const _requests = requests || []

        const headers = this.#getHeaders()
        const raw = JSON.stringify({
            "requests": [
                {
                    "id": "index",
                    "json": {
                        "context": IOT_CAT_CONTEXT,
                        "token": IOT_CAT_TOKEN,
                        "useResizeSensor": true
                    }
                },
                ..._requests
            ]
        });
        const requestOptions: RequestInit = {
            method: 'POST',
            headers,
            body: raw,
            redirect: 'follow'
        }

        const response = await fetch(`${this.baseURL}/api/generateURLParameters`, requestOptions)
        const query = await response.json()

        return `${this.baseURL}/embedded${path}?${query}`

    }

    async getElementsIdInfo(pageName: string): Promise<ElementIdInfo[]> {
        const headers = this.#getHeaders()
        const url = `${this.baseURL}/api/getTPIElementsId?pageName=${pageName}`
        const requestOptions: RequestInit = {
            method: 'GET',
            headers,
            redirect: 'follow'
        }
        const response = await fetch(url, requestOptions)
        return response.json()
    }




}