import { NgModule } from '@angular/core';
import {
  ActivatedRoute,
  NavigationEnd,
  Router,
  RouterModule,
  Routes,
} from '@angular/router';

import { Title, Meta } from '@angular/platform-browser';
import { filter, map } from 'rxjs/operators';
import { DashboardSkeletonComponent } from './pages/dashboard-skeleton/dashboard-skeleton.component';
import { AboutUsPageComponent } from './pages/about-us/about-us-page.component';
import { LoginComponent } from './pages/login/login.component';
import { AdminDashboardComponent } from './pages/admin/admin-dashboard/admin-dashboard.component';
import { AdminLandingComponent } from './pages/admin/admin-landing/admin-landing.component';
import { AdministratorDetailsComponent } from './pages/admin/administrator/administrator-details/administrator-details.component';
import { AdministratorListComponent } from './pages/admin/administrator/administrator-list/administrator-list.component';
import { AdministratorOnboardingComponent } from './pages/admin/administrator/administrator-onboarding/administrator-onboarding.component';
import { MemberDetailsComponent } from './pages/admin/member/member-details/member-details.component';
import { MemberListComponent } from './pages/admin/member/member-list/member-list.component';
import { MemberOnboardingComponent } from './pages/admin/member/member-onboarding/member-onboarding.component';
import { TicketComponent } from './pages/admin/ticket/ticket.component';
import { TraderDetailsComponent } from './pages/admin/trader/trader-details/trader-details.component';
import { TraderListComponent } from './pages/admin/trader/trader-list/trader-list.component';
import { TradingAccountDetailsComponent } from './pages/admin/trader/trading-account-details/trading-account-details.component';
import { TradingTokensComponent } from './pages/admin/trader/trading-tokens/trading-tokens.component';
import { TrustedSourceDetailsComponent } from './pages/admin/trusted-source/trusted-source-details/trusted-source-details.component';
import { TrustedSourceListComponent } from './pages/admin/trusted-source/trusted-source-list/trusted-source-list.component';
import { TrustedSourceOnboardingComponent } from './pages/admin/trusted-source/trusted-source-onboarding/trusted-source-onboarding.component';
import { AssetPublishmentComponent } from './pages/asset-publishment/asset-publishment.component';
import { FdacComponent } from './pages/fdac/fdac.component';
import { FdacSearchComponent } from './pages/fdac-search/fdac-search.component';
import { HelpdeskPageComponent } from './pages/helpdesk/helpdesk-page.component';
import { HomePageComponent } from './pages/home-page/home-page.component';
import { LearningCentreComponent } from './pages/learning-centre/learning-centre.component';
import { MemberLoginComponent } from './pages/member-login/member-login.component';
import { PolicyComponent } from './pages/policy/policy.component';
import { AccountRedemptionComponent } from './pages/profile-page-account/account-redemption/account-redemption.component';
import { AccountTerminationComponent } from './pages/profile-page-account/account-termination/account-termination.component';
import { AccountTokensComponent } from './pages/profile-page-account/account-tokens/account-tokens.component';
import { AccountTradesComponent } from './pages/profile-page-account/account-trades/account-trades.component';
import { ProfilePageAccountComponent } from './pages/profile-page-account/profile-page-account.component';
import { ProfilePageAssetComponent } from './pages/profile-page-asset/profile-page-asset.component';
import { ProfilePageOverviewComponent } from './pages/profile-page-overview/profile-page-overview.component';
import { ProfilePageReviewComponent } from './pages/profile-page-review/profile-page-review.component';
import { ProfilePageTicketComponent } from './pages/profile-page-ticket/profile-page-ticket.component';
import { ProfilePageTradeComponent } from './pages/profile-page-trade/profile-page-trade.component';
import { SearchPageComponent } from './pages/search-page/search-page.component';
import { ComponentDetailsWithHeader } from './components/component-details/component-details-with-header.component';
import { ValidationDetailsWithHeader } from './components/validation-details/validation-details-with-header.component';
import { OfferingDetailstComponent } from './pages/offering-details/offering-details.component';
import { OfferingDefinitionComponent } from './pages/offering-definition/offering-definition.component';
import { PatComponent } from './pages/pat/pat.component';
import { TradeOnboardingComponent } from './pages/trade-onboarding/trade-onboarding.component';
import { PrivacyPolicyComponent } from './pages/privacy-policy/privacy-policy.component';
import { CoreValueComponent } from './pages/core-value/core-value.component';
import { TrainingDetails } from './components/training-details/training-details.component';
import { TrainingDetailsWithHeader } from './components/training-details/training-details-with-header.component';
import { LegalFrameworkComponent } from './pages/framework/legal-framework/legal-framework.component';
import { BusinessFrameworkComponent } from './pages/framework/business-framework/business-framework.component';
import { TechnologyFrameworkComponent } from './pages/framework/technology-framework/technology-framework.component';
import { PurchasedOffersComponent } from './pages/purchased-offers/purchased-offers.component';


const routes: Routes = [
  {
    path: '',
    component: HomePageComponent,
    data: { title: 'Home Page', description: 'Home page', keywords: 'home, angular' }
  },
  
  {
    path: 'under-construction',
    component: DashboardSkeletonComponent,
    data: { title: 'Under Construction', description: 'Under Construction', keywords: 'Dashboard Skeleton, angular' }
  },
  {
    path: 'legal-framework',
    component: LegalFrameworkComponent,
    data: { title: 'Legal Framework', description: 'Legal Framework', keywords: 'Legal Framework, angular' }
  },
  {
    path: 'business-framework',
    component: BusinessFrameworkComponent,
    data: { title: 'Business Framework', description: 'Business Framework', keywords: 'Business Framework, angular' }
  },
  {
    path: 'technology-framework',
    component: TechnologyFrameworkComponent,
    data: { title: 'Technology Framework', description: 'Technology Framework', keywords: 'Technology Framework, angular' }
  },
  // MAIN PAGES
  {
    path: 'about-us',
    component: AboutUsPageComponent,
    data: { title: 'About Us', description: 'About Us', keywords: 'About Us, angular' }
  },
  {
    path: 'helpdesk',
    component: HelpdeskPageComponent,
    data: { title: 'Helpdesk', description: 'Helpdesk', keywords: 'Helpdesk, angular' }
  },
  
  {
    path: 'login',
    component: LoginComponent,
    data: { title: 'Login', description: 'Login', keywords: 'Login, angular' }
  },
  {
    path: 'terms-and-conditions',
    component: PolicyComponent,
    data: { title: 'Terms and Conditions', description: 'Terms and Conditions', keywords: 'Terms and Conditions, angular' }
  },
  {
    path: 'privacy-policy',
    component: PrivacyPolicyComponent,
    data: { title: 'Privacy Policy', description: 'Privacy Policy', keywords: 'Privacy Policy, angular' }
  },
  {
    path: 'core-value',
    component: CoreValueComponent,
    data: { title: 'Core Value', description: 'Core Value', keywords: 'Core Value, angular' }
  },
  // ACCOUNT PAGES
  {
    path: 'account-redemption',
    component: AccountRedemptionComponent,
    data: { title: 'Account redemption', description: 'Account redemption', keywords: 'Account redemption, angular' }
  },
  {
    path: 'account-termination',
    component: AccountTerminationComponent,
    data: { title: 'Account termination', description: 'Account termination', keywords: 'Account termination, angular' }
  },
  {
    path: 'account-tokens',
    component: AccountTokensComponent,
    data: { title: 'Account tokens', description: 'Account tokens', keywords: 'Account tokens, angular' }
  },
  {
    path: 'account-trades',
    component: AccountTradesComponent,
    data: { title: 'Account trades', description: 'Account trades', keywords: 'Account trades, angular' }
  },

  // PROFILE PAGES
  {
    path: 'profile-overview',
    component: ProfilePageOverviewComponent,
    data: { title: 'Profile Overview', description: 'Profile Overview', keywords: 'Profile Overview, angular' }
  },
  // {
  //   path: 'profile-account',
  //   component: ProfilePageAccountComponent,
  //   data: { title: 'Profile Account', description: 'Profile Account', keywords: 'Profile Account, angular' }
  // },
  {
    path: 'profile-asset',
    component: ProfilePageAssetComponent,
    data: { title: 'Profile Asset', description: 'Profile Asset', keywords: 'Profile Asset, angular' }
  },
  {
    path: 'profile-trade',
    component: ProfilePageTradeComponent,
    data: { title: 'Profile Trade', description: 'Profile Trade', keywords: 'Profile Trade, angular' }
  },
  {
    path: 'profile-review',
    component: ProfilePageReviewComponent,
    data: { title: 'Profile Review', description: 'Profile Review', keywords: 'Profile Review, angular' }
  },
  {
    path: 'profile-ticket',
    component: ProfilePageTicketComponent,
    data: { title: 'Profile Ticket', description: 'Profile Ticket', keywords: 'Profile Ticket, angular' }
  },
  {
    path: 'purchased-offers',
    component: PurchasedOffersComponent,
    data: { title: 'Purchased Offers', description: 'View your purchased offers with detailed information', keywords: 'purchased offers, offers, subscription, payg, payu' }
  },

  // OTHER PAGES
  {
    path: 'member-login',
    component: MemberLoginComponent,
    data: { title: 'Member Login', description: 'Member Login', keywords: 'Member Login, angular' }
  },
  {
    path: 'asset-publishment/:aid',
    component: AssetPublishmentComponent,
    data: { title: 'Edit Asset', description: 'Edit Asset', keywords: 'Edit Asset, angular' }
  },
  {
    path: 'asset-publishment',
    component: AssetPublishmentComponent,
    data: { title: 'Asset Publishment', description: 'Asset Publishment', keywords: 'Asset Publishment, angular' }
  },
  {
    path: 'search',
    component: SearchPageComponent,
    data: { title: 'Advanced Search', description: 'Advanced Search', keywords: 'Advanced Search, angular' }
  },
  // FDAC - LC PAGES
  // {
  //   path: 'fdac',
  //   component: FdacComponent,
  //   data: { title: 'FDAC', description: 'FDAC', keywords: 'FDAC, angular' }
  // },
  {
    path: 'fdac',
    component: FdacSearchComponent,
    data: { title: 'FDAC', description: 'FDAC', keywords: 'FDAC, angular' }
  },
  {
    path: 'learning-centre',
    component: LearningCentreComponent,
    data: { title: 'Learning Centre', description: 'Learning Centre', keywords: 'Learning Centre, angular' }
  },
  {
    path: 'asset/:id',
    component: ComponentDetailsWithHeader,
    data: { title: 'Asset', description: 'Asset', keywords: 'IoT Catalogue, asset' }
  },
  {
    path: 'learning-centre/:id',
    component: TrainingDetailsWithHeader,
    data: { title: 'Learning Centre', description: 'Asset', keywords: 'IoT Catalogue, asset' }
  },
  {
    path: 'asset/:aid/offering-details/:oid',
    component: OfferingDetailstComponent,
    data: { title: 'Offering Details', description: 'Offering Details', keywords: 'Offering Details, angular' }
  },
  {
    path: 'learning-centre',
    component: LearningCentreComponent,
    data: { title: 'Learning Centre', description: 'Learning Centre', keywords: 'Learning Centre, angular' }
  },
  {
    path: 'validation/:id',
    component: ValidationDetailsWithHeader,
    data: { title: 'Validation', description: 'Validation', keywords: 'IoT Catalogue, validation' }
  },
  // ADMIN PAGES
  {
    path: 'admin-dashboard',
    component: AdminDashboardComponent,
    data: { title: 'Admin dashboard', description: 'Admin dashboard', keywords: 'Admin dashboard, angular' }
  },
  {
    path: 'admin-landing',
    component: AdminLandingComponent,
  },
  {
    path: 'administrator-details',
    component: AdministratorDetailsComponent,
    data: { title: 'Administrator details', description: 'Administrator details', keywords: 'administrator details, angular', breadcrumb: 'details' }
  },
  {
    path: 'administrator-list',
    component: AdministratorListComponent,
    data: { title: 'Administrator List', description: 'Administrator List', keywords: 'administrator list, angular', breadcrumb: 'list' }
  },
  {
    path: 'administrator-onboarding',
    component: AdministratorOnboardingComponent,
    data: { title: 'Administrator onboarding', description: 'Administrator onboarding', keywords: 'administrator onboarding, angular', breadcrumb: 'onboarding' }
  },

  {
    path: 'member-details',
    component: MemberDetailsComponent,
    data: { title: 'Member details', description: 'Member details', keywords: 'Member details, angular' }
  },
  {
    path: 'member-list',
    component: MemberListComponent,
    data: { title: 'Member list', description: 'Member list', keywords: 'Member list, angular' }
  },
  {
    path: 'member-onboarding',
    component: MemberOnboardingComponent,
    data: { title: 'Member onboarding', description: 'Member onboarding', keywords: 'Member onboarding, angular' }
  },

  {
    path: 'ticket',
    component: TicketComponent,
    data: { title: 'Ticket', description: 'Ticket', keywords: 'Ticket, angular' }
  },

  {
    path: 'trader-details',
    component: TraderDetailsComponent,
    data: { title: 'Trader details', description: 'Trader details', keywords: 'Trader details, angular' }
  },
  {
    path: 'trader-list',
    component: TraderListComponent,
    data: { title: 'Trader list', description: 'Trader list', keywords: 'Trader list, angular' }
  },
  {
    path: 'trading-account-details',
    component: TradingAccountDetailsComponent,
    data: { title: 'Trading account details', description: 'Trading account details', keywords: 'Trading account details, angular' }
  },
  {
    path: 'trading-tokens',
    component: TradingTokensComponent,
    data: { title: 'Trading tokens', description: 'Trading tokens', keywords: 'Trading tokens, angular' }
  },

  {
    path: 'trusted-source-details',
    component: TrustedSourceDetailsComponent,
    data: { title: 'Trusted source details', description: 'Trusted source details', keywords: 'Trusted source details, angular' }
  },
  {
    path: 'trusted-source-list',
    component: TrustedSourceListComponent,
    data: { title: 'Trusted source list', description: 'Trusted source list', keywords: 'Trusted source list, angular' }
  },
  {
    path: 'trusted-source-onboarding',
    component: TrustedSourceOnboardingComponent,
    data: { title: 'Trusted source onboarding', description: 'Trusted source onboarding', keywords: 'Trusted source onboarding, angular' }
  },
  {
    path: 'offering-definition',
    component: OfferingDefinitionComponent,
    data: { title: 'Offering Definition', description: 'Offering Definition', keywords: 'Offering definition, angular' }
  },
  {
    path: 'offering-details',
    component: OfferingDetailstComponent,
    data: { title: 'Offering Details', description: 'Offering Details', keywords: 'Offering Details, angular' }
  },
  {
    path: 'trade-onboarding',
    component: TradeOnboardingComponent,
    data: { title: 'Trade onboarding', description: 'Trade onboarding', keywords: 'Trade onboarding, angular' }
  },
  // PAT page
  {
    path: 'pat',
    component: PatComponent,
    data: { title: 'Pricing Advisory Tool', description: 'Pricing Advisory Tool', keywords: 'Pricing Advisory Tool, angular' }
  },

];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule],
})
export class AppRoutingModule {
  constructor(
    private titleService: Title,
    private metaService: Meta,
    private router: Router,
    private activatedRoute: ActivatedRoute
  ) {
    this.router.events
      .pipe(
        filter((event) => event instanceof NavigationEnd),
        map(() => {
          let child = this.activatedRoute.firstChild;
          while (child?.firstChild) {
            child = child.firstChild;
          }
          return child?.snapshot.data;
        })
      )
      .subscribe((data) => {
        if (data && data['title']) {
          this.titleService.setTitle(data['title']);
        }
        if (data && data['description']) {
          this.metaService.updateTag({
            name: 'description',
            content: data['description'],
          });
        }
        if (data && data['keywords']) {
          this.metaService.updateTag({
            name: 'keywords',
            content: data['keywords'],
          });
        }
      });
  }
}