import { DEFAULT_CURRENCY_CODE, NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
// Imports from Angular Material
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { MatInputModule } from '@angular/material/input';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonModule } from '@angular/material/button';
import { MatExpansionModule } from '@angular/material/expansion';
import { MatSidenavModule } from '@angular/material/sidenav';
import { MatListModule } from '@angular/material/list';
import { MatToolbarModule } from '@angular/material/toolbar';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatSelectModule } from '@angular/material/select';
import { MatDialogModule } from '@angular/material/dialog';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatNativeDateModule } from '@angular/material/core';
import { MatFormFieldModule } from '@angular/material/form-field';
import { JsonPipe, NgIf } from '@angular/common';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { MatChipsModule } from '@angular/material/chips';
import { MatTableModule } from '@angular/material/table';
import { MatPaginatorModule } from '@angular/material/paginator';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { MatCardModule } from '@angular/material/card';
import { MatRadioModule } from '@angular/material/radio';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatGridListModule } from '@angular/material/grid-list';
// import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import {MatProgressSpinnerModule} from '@angular/material/progress-spinner';

// chart library
import { NgxChartsModule } from '@swimlane/ngx-charts';
// Dashbarod Skeleton Page
import { DashboardSkeletonComponent } from './pages/dashboard-skeleton/dashboard-skeleton.component';
// Auth Module
import { CommonModule } from '@angular/common';
import { QRCodeModule } from 'angularx-qrcode';
import { AuthenticationComponent } from './components/authentication/authentication.component';
// Pages
import { AboutUsPageComponent } from './pages/about-us/about-us-page.component';
import { LoginComponent } from './pages/login/login.component';
import { HomePageComponent } from './pages/home-page/home-page.component';
import { HelpdeskPageComponent } from './pages/helpdesk/helpdesk-page.component';
import { PolicyComponent } from './pages/policy/policy.component';
import { AccountRedemptionComponent } from './pages/profile-page-account/account-redemption/account-redemption.component';
import { AccountTerminationComponent } from './pages/profile-page-account/account-termination/account-termination.component';
import { AccountTokensComponent } from './pages/profile-page-account/account-tokens/account-tokens.component';
import { AccountTradesComponent } from './pages/profile-page-account/account-trades/account-trades.component';
import { AssetPublishmentComponent } from './pages/asset-publishment/asset-publishment.component';
import { FdacComponent } from './pages/fdac/fdac.component';
import { LearningCentreComponent } from './pages/learning-centre/learning-centre.component';
import { MemberLoginComponent } from './pages/member-login/member-login.component';
import { ProfilePageAccountComponent } from './pages/profile-page-account/profile-page-account.component';
import { ProfilePageAssetComponent } from './pages/profile-page-asset/profile-page-asset.component';
import { ProfilePageOverviewComponent } from './pages/profile-page-overview/profile-page-overview.component';
import { ProfilePageReviewComponent } from './pages/profile-page-review/profile-page-review.component';
import { ProfilePageTicketComponent } from './pages/profile-page-ticket/profile-page-ticket.component';
import { ProfilePageTradeComponent } from './pages/profile-page-trade/profile-page-trade.component';
import { SearchPageComponent } from './pages/search-page/search-page.component';
import { OfferingDetailstComponent } from './pages/offering-details/offering-details.component';
import { TradeAccountSetupComponent } from './pages/trade-onboarding/trade-account-setup/trade-account-setup.component';
import { TradeOnboardingComponent } from './pages/trade-onboarding/trade-onboarding.component';
import { TradeAccountInfoComponent } from './pages/trade-onboarding/trade-account-info/trade-account-info.component';
import { PatComponent } from './pages/pat/pat.component';
import { OfferingDefinitionComponent } from './pages/offering-definition/offering-definition.component';
// Admin Pages
import { AdminDashboardComponent } from './pages/admin/admin-dashboard/admin-dashboard.component';
import { AdminLandingComponent } from './pages/admin/admin-landing/admin-landing.component';
import { AdministratorDetailsComponent } from './pages/admin/administrator/administrator-details/administrator-details.component';
import { AdministratorListComponent } from './pages/admin/administrator/administrator-list/administrator-list.component';
import { AdministratorOnboardingComponent } from './pages/admin/administrator/administrator-onboarding/administrator-onboarding.component';
import { MemberDetailsComponent } from './pages/admin/member/member-details/member-details.component';
import { MemberListComponent } from './pages/admin/member/member-list/member-list.component';
import { MemberOnboardingComponent } from './pages/admin/member/member-onboarding/member-onboarding.component';
import { TicketComponent } from './pages/admin/ticket/ticket.component';
import { TraderDetailsComponent } from './pages/admin/trader/trader-details/trader-details.component';
import { TraderListComponent } from './pages/admin/trader/trader-list/trader-list.component';
import { TradingAccountDetailsComponent } from './pages/admin/trader/trading-account-details/trading-account-details.component';
import { TradingTokensComponent } from './pages/admin/trader/trading-tokens/trading-tokens.component';
import { TrustedSourceDetailsComponent } from './pages/admin/trusted-source/trusted-source-details/trusted-source-details.component';
import { TrustedSourceListComponent } from './pages/admin/trusted-source/trusted-source-list/trusted-source-list.component';
import { TrustedSourceOnboardingComponent } from './pages/admin/trusted-source/trusted-source-onboarding/trusted-source-onboarding.component';
// Directive
import { BubblePaginationDirective } from './pagination.directive';
// Added primeng library module
import { InputTextModule } from 'primeng/inputtext';
import { ButtonModule } from 'primeng/button';
import { SliderModule } from 'primeng/slider';
import { DropdownModule } from 'primeng/dropdown';
import { CardModule } from 'primeng/card';
import { DividerModule } from 'primeng/divider';
import { KnobModule } from 'primeng/knob';
import { CheckboxModule } from 'primeng/checkbox';
// HTTP imports
import { HTTP_INTERCEPTORS, HttpClientModule } from '@angular/common/http';
// Header Interceptor
import { HeaderInterceptor } from './services/header-interceptor';
// components
import { SearchResultsComponent } from './components/search-results/search-results.component';
import { BreadcrumbSimpleComponent } from './components/breadcrumb-simple/breadcrumb-simple.component';
import { ChatbotComponent } from './components/chatbot/chatbot.component';
import { ConversationComponent } from './components/conversation/conversation.component';
import { PromptComponent } from './components/chatbot/prompt/prompt.component';
import { ComponentDetails } from './components/component-details/component-details.component';
import { ComponentList } from './components/component-list/component-list.component';
// dialogs
import { DialogNewTicketComponent } from './components/dialog-new-ticket/dialog-new-ticket.component';
import { DialogOfferingLogComponent } from './components/dialog-offering-log/dialog-offering-log.component';
import { DialogPublishingLogComponent } from './components/dialog-publishing-log/dialog-publishing-log.component';
import { DialogTradingLogComponent } from './components/dialog-trading-log/dialog-trading-log.component';
import { DialogTrendingLogComponent } from './components/dialog-trending-log/dialog-trending-log.component';
import { DialogViewTicketComponent } from './components/dialog-view-ticket/dialog-view-ticket.component';
// components
import { NavigationBarComponent } from '../app/components/navigation-bar/navigation-bar.component';
import { NavigationBarAdminComponent } from './components/navigation-bar-admin/navigation-bar-admin.component';
import { FooterSectionComponent } from '../app/components/footer-section/footer-section.component';
import { PageHeaderComponent } from './components/page-header/page-header.component';
import { ResponsiveSidenavAdminComponent } from './components/responsive-sidenav-admin/responsive-sidenav-admin.component';
import { ResponsiveSidenavEndUserComponent } from './components/responsive-sidenav-end-user/responsive-sidenav-end-user.component';
import { ScrollTopComponent } from './components/scroll-top/scroll-top.component';
import { StickyMenuComponent } from './components/sticky-menu/sticky-menu.component';

import { TrainingList } from './components/training-list/training-list.component';
import { ValidationDetails } from './components/validation-details/validation-details.component';
import { ComponentDetailsWithHeader } from './components/component-details/component-details-with-header.component';
import { ValidationDetailsWithHeader } from './components/validation-details/validation-details-with-header.component';
import { MatTooltipModule } from '@angular/material/tooltip';
import { PrivacyPolicyComponent } from './pages/privacy-policy/privacy-policy.component';
import {MatCheckboxModule} from '@angular/material/checkbox';
import {MatStepperModule} from '@angular/material/stepper';
import { MatSliderModule } from '@angular/material/slider'; 
import { CoreValueComponent } from './pages/core-value/core-value.component';
import { TrainingDetailsWithHeader } from './components/training-details/training-details-with-header.component';
import { TrainingDetails } from './components/training-details/training-details.component';
import { TechnologyFrameworkComponent } from './pages/framework/technology-framework/technology-framework.component';
import { BusinessFrameworkComponent } from './pages/framework/business-framework/business-framework.component';
import { LegalFrameworkComponent } from './pages/framework/legal-framework/legal-framework.component';
import { ChatWidgetComponent } from './components/chat-widget/chat-widget.component';
import { PurchasedOffersComponent } from './pages/purchased-offers/purchased-offers.component';
import { PatDialogComponent } from './components/pat-dialog/pat-dialog.component';
import { ArchiveOfferingDialogComponent } from './components/archive-offering-dialog/archive-offering-dialog.component';
import { ApproveAllowanceDialogComponent } from './components/approve-allowance-dialog/approve-allowance-dialog.component';
import { EditAssetConfirmationDialogComponent } from './components/edit-asset-confirmation-dialog/edit-asset-confirmation-dialog.component';
import { UnpublishAssetConfirmationDialogComponent } from './components/unpublish-asset-confirmation-dialog/unpublish-asset-confirmation-dialog.component';
import { FdacSearchComponent } from './pages/fdac-search/fdac-search.component';
import { MarkdownPreviewModalComponent } from './components/markdown-preview-modal/markdown-preview-modal.component';
// Custom validators
import { TEXT_VALIDATOR_DIRECTIVES } from './validators/text-validators';


@NgModule({
  declarations: [
    AppComponent,
    DashboardSkeletonComponent,
    TechnologyFrameworkComponent,
    BusinessFrameworkComponent,
    LegalFrameworkComponent,
    AboutUsPageComponent,
    FooterSectionComponent,
    StickyMenuComponent,
    AuthenticationComponent,
    // main pages
    HomePageComponent,
    HelpdeskPageComponent,
    AboutUsPageComponent,
    PolicyComponent,
    PrivacyPolicyComponent,
    CoreValueComponent,
    AccountRedemptionComponent,
    AccountTerminationComponent,
    AccountTokensComponent,
    AccountTradesComponent,
    // profile pages
    ProfilePageOverviewComponent,
    ProfilePageTradeComponent,
    ProfilePageTicketComponent,
    ProfilePageReviewComponent,
    ProfilePageAssetComponent,
    ProfilePageAccountComponent,
    // tm and advanced-search
    MemberLoginComponent,
    AssetPublishmentComponent,
    SearchPageComponent,
    OfferingDefinitionComponent,
    OfferingDetailstComponent,
    PatComponent,
    TradeAccountSetupComponent,
    TradeAccountInfoComponent,
    // Added plugin pages
    FdacComponent,
    FdacSearchComponent,
    LearningCentreComponent,
    // admin
    AdminDashboardComponent,
    AdminLandingComponent,
    AdministratorDetailsComponent,
    AdministratorListComponent,
    AdministratorOnboardingComponent,
    MemberDetailsComponent,
    MemberListComponent,
    MemberOnboardingComponent,
    TicketComponent,
    TraderDetailsComponent,
    TraderListComponent,
    TradingAccountDetailsComponent,
    TradingTokensComponent,
    TrustedSourceDetailsComponent,
    TrustedSourceListComponent,
    TrustedSourceOnboardingComponent,
    // trade-onboarding
    TradeOnboardingComponent,
    // components
    FooterSectionComponent,
    StickyMenuComponent,
    DialogNewTicketComponent,
    ScrollTopComponent,
    ResponsiveSidenavEndUserComponent,
    ResponsiveSidenavAdminComponent,
    NavigationBarAdminComponent,
    DialogPublishingLogComponent,
    DialogOfferingLogComponent,
    DialogTrendingLogComponent,
    DialogTradingLogComponent,
    DialogViewTicketComponent,
    SearchResultsComponent,
    PageHeaderComponent,
    BreadcrumbSimpleComponent,
    // directive
    BubblePaginationDirective,
    LoginComponent,
    ComponentDetailsWithHeader,
    TrainingDetailsWithHeader,
    ValidationDetailsWithHeader,
    ChatbotComponent,
    ConversationComponent,
    PromptComponent,
    // chat
    ChatWidgetComponent,
    // purchased offers
    PurchasedOffersComponent,
    PatDialogComponent,
    ArchiveOfferingDialogComponent,
    ApproveAllowanceDialogComponent,
    EditAssetConfirmationDialogComponent,
    UnpublishAssetConfirmationDialogComponent,
    MarkdownPreviewModalComponent,
    // Custom validators
    ...TEXT_VALIDATOR_DIRECTIVES
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    BrowserAnimationsModule,
    HttpClientModule,
    QRCodeModule,
    MatInputModule,
    MatIconModule,
    MatButtonModule,
    MatExpansionModule,
    MatSidenavModule,
    MatListModule,
    MatToolbarModule,
    MatSelectModule,
    FormsModule,
    ReactiveFormsModule,
    MatDialogModule,
    MatDatepickerModule,
    MatNativeDateModule,
    MatFormFieldModule,
    NgIf,
    JsonPipe,
    MatButtonToggleModule,
    MatChipsModule,
    MatTableModule,
    MatPaginatorModule,
    MatSlideToggleModule,
    MatCardModule,
    MatSnackBarModule,
    MatProgressSpinnerModule,
    // chart
    NgxChartsModule,
    // out animations
    // NoopAnimationsModule,
    CommonModule,
    NavigationBarComponent,
    ComponentList,
    ComponentDetails,
    TrainingDetails,
    ValidationDetails,
    TrainingList,
    InputTextModule,
    ButtonModule,
    SliderModule,
    DropdownModule,
    CardModule,
    DividerModule,
    KnobModule,
    CheckboxModule,
    MatRadioModule,
    MatGridListModule,
    MatTooltipModule,
    MatCheckboxModule,
    MatStepperModule,
    MatSliderModule
  ],
  exports: [
    StickyMenuComponent,
    SearchResultsComponent,
    FooterSectionComponent,
  ],
  providers: [
    {
      provide: HTTP_INTERCEPTORS,
      useClass: HeaderInterceptor,
      multi: true,
    },
    { provide: DEFAULT_CURRENCY_CODE, useValue: 'EUR' },
  ],
  bootstrap: [AppComponent],
})
export class AppModule {}
