import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';

export interface ApproveAllowanceDialogData {
  currentAllowance: number;
  requiredAmount: number;
  offeringTitle: string;
}

@Component({
  selector: 'app-approve-allowance-dialog',
  templateUrl: './approve-allowance-dialog.component.html',
  styleUrls: ['./approve-allowance-dialog.component.scss']
})
export class ApproveAllowanceDialogComponent {

  constructor(
    private dialogRef: MatDialogRef<ApproveAllowanceDialogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: ApproveAllowanceDialogData
  ) {}

  close() {
    this.dialogRef.close(false);
  }
}
