import { Component } from '@angular/core';
import { ChatService } from '../../services/chat.service';

@Component({
  selector: 'app-chat-widget',
  templateUrl: './chat-widget.component.html',
  styleUrls: ['./chat-widget.component.scss'],
})
export class ChatWidgetComponent {
  isOpen = false;
  loading = true;

  constructor(private chatService: ChatService) {
    this.chatService.chatbotVisible$.subscribe(state => {
      this.isOpen = state;
      this.loading = state; // reset loading when opening
    });
  }

  toggleChat() {
    this.chatService.toggleChatbot();
  }

  onIframeLoad() {
    setTimeout(() => {
      this.loading = false;
    }, 300);
  }
}