import { Component, OnInit } from '@angular/core';
import { ChatBotService } from './chatbot.service';  // Chatbot service for handling AI logic
import { IConversationMessage } from 'src/app/interfaces/conversation-message.interface';

@Component({
  selector: 'app-chatbot',
  templateUrl: './chatbot.component.html',
  styleUrls: ['./chatbot.component.scss']
})
export class ChatbotComponent implements OnInit {
  public messages: IConversationMessage[] = [];
  chatboxOpen: boolean = true;  // Ensure chatbox is open by default

  constructor(private chatBotService: ChatBotService) {}

  ngOnInit() {
    this.messages = this.chatBotService.messages;
  }

  handlePromptChange(userInput: string) {
    this.messages.push({
      from: 'user',
      text: userInput
    });

    this.chatBotService.submitPrompt(userInput).subscribe({
      next: (res) => {
        setTimeout(() => {
          this.messages.push({
            from: 'bot',
            text: res.choices[0].text.trim()
          });
        }, 500);
      },
      error: (err) => {
        setTimeout(() => {
          this.messages.push({
            from: 'bot',
            text: err.error?.error?.message || 'Error processing your message.'
          });
        }, 500);
      }
    });
  }
}