import { Component, Output, EventEmitter } from '@angular/core';

@Component({
  selector: 'app-prompt',
  templateUrl: './prompt.component.html',
  styleUrls: ['./prompt.component.scss']
})
export class PromptComponent {
  userInput: string = '';
  @Output() textChange = new EventEmitter<string>();

  sendMessage() {
    if (this.userInput.trim()) {
      this.textChange.emit(this.userInput.trim());
      this.userInput = ''; // Clear the input after sending
    }
  }
}