import { DOCUMENT, ViewportScroller } from "@angular/common";
import { AfterViewInit, Component, inject } from "@angular/core";
import { Observable, fromEvent, map } from "rxjs";

@Component({
  selector: 'component-details-with-header',

  template: `
    <head>
      <meta charset="utf-8" />
      <!-- other meta tags -->
      <script src="https://website-widgets.pages.dev/dist/sienna.min.js"></script>
      <style>
      .main-content {
        flex: 1 0 auto; /* fills the space between header and footer */
      }
      
      app-footer-section {
        flex-shrink: 0;  /* stays at the bottom */
      }

      .spacer {
        height: 5vh;
      }

      @media screen and (min-width: 1800px) {
        .spacer {
          height: 4vh;
        }
      }
      @media screen and (min-width: 2100px) {
        .spacer {
          height: 1vh;
        }
      }
      </style>
    </head>
    <body>
      <div class="page-container">
        <app-sticky-menu></app-sticky-menu>
        <app-navigation-bar></app-navigation-bar>

        <div class="main-content">
  
        <div style="margin-top:85px">
           <app-page-header
            
            [breadcrumbs]="breadcrumbs" [ngStyle]="{'margin-bottom': '0'}"
          ></app-page-header>
        </div>

          <component-details></component-details>
        </div>
        <div class="spacer"></div>
        <app-footer-section
          style="left: 0;right: 0;"
        ></app-footer-section>
        <app-scroll-top
          *ngIf="showScroll$ | async"
          (scrollToTop)="onScrollToTop()"
        ></app-scroll-top>
      </div>
    </body>
  `,
  styleUrls: [],
})
export class ComponentDetailsWithHeader implements AfterViewInit {

  ngAfterViewInit(): void {
    const script = document.createElement('script');
    script.src = 'https://website-widgets.pages.dev/dist/sienna.min.js';
    script.async = true;  // or false, depending on your needs

    script.onload = () => {
      console.log('Sienna script loaded!');
      // Optionally, call any global functions provided by the script
      // For example: window['Sienna']?.init(...);
    };

    // Append the script element to the document head (or body)
    document.head.appendChild(script);
  }

  breadcrumbs = [
    { label: 'Assets', url: '/fdac' },
    { label: 'Asset details', url: '/' },
  ];

  private readonly document = inject(DOCUMENT);
  private readonly viewport = inject(ViewportScroller);
  readonly showScroll$: Observable<boolean> = fromEvent(
    this.document,
    'scroll'
  ).pipe(
    map(() => this.viewport.getScrollPosition()?.[1] > 0)
  );

  onScrollToTop(): void {
    this.viewport.scrollToPosition([0, 0]);
  }
}