import { Component, ElementRef, inject, ViewChild } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent, IframeProps } from '../iframe/iframe.component';
import { Loading } from '../iframe/loading.component';
import { SnackbarService } from 'src/app/services/snackbar/snackbar.service';
import { OpenAPIService } from 'src/app/services/open-api.service';
import { ElementList } from '../element-list/element-list.component';

@Component({
    selector: 'component-list',
    standalone: true,
    imports: [CommonModule, IframeComponent, Loading],
    template: `
    <div *ngIf="this.iframeProps === null">
        <loading-component ></loading-component>
    </div>

    <div style="margin-top:1rem;margin-left:2rem;margin-right:2rem;width:92%" *ngIf="this.iframeProps !== null">
        <iframe-component #iframe class=" bg-black" [iframeProps]="this.iframeProps"></iframe-component>
    </div>
`,
    styleUrls: ["./component-list.component.scss"],
})
export class ComponentList extends ElementList {
    snackbarService: SnackbarService = inject(SnackbarService);

    token: string | null = null;
    authorizedIds: string[] | null
    @ViewChild("iframe")
    set setIframe(el: IframeComponent) {

        this.iframe = el
    };
    constructor() {
        super()
        this.authorizedIds = null
        this.iframeProps = null
    }

    async ngOnInit() {
        try {
            // Generates the iframe url with a list with the authorized assets
            const itemsPerPage = 18

            // Obtains an iframe with a list of the authorized assets
            const { value: url, status } = await this.openAPIService.generateAssetListIframeURL(itemsPerPage)
            if (status === 200) this.iframeProps = { url };

            // Show success snackbar
            // this.snackbarService.success('Components loaded successfully.', 'Close', 6000);
        } catch (error) {
            console.error('Error loading components:', error);

            // Show error snackbar
            this.snackbarService.error('Failed to load components. Please try again.', 'Close', 6000);
        }
    }
}