import { Component, Input, ElementRef, AfterViewChecked, ViewChild } from '@angular/core';
import { IConversationMessage } from 'src/app/interfaces/conversation-message.interface';

@Component({
  selector: 'app-conversation',
  templateUrl: './conversation.component.html',
  styleUrls: ['./conversation.component.scss']
})
export class ConversationComponent implements AfterViewChecked {
  @Input() messages: IConversationMessage[] = [];
  @ViewChild('conversationContainer', { static: true }) conversationContainer!: ElementRef<HTMLDivElement>;

  ngAfterViewChecked(): void {
    const element = this.conversationContainer.nativeElement;
    element.scrollTop = element.scrollHeight;
  }
}