import { Component } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';
import { MAT_DATE_FORMATS } from '@angular/material/core';
   
export const MY_DATE_FORMATS = {
    parse: {
      dateInput: 'DD/MM/YYYY',
    },
    display: {
      dateInput: 'DD/MM/YYYY',
      monthYearLabel: 'MMMM YYYY',
      dateA11yLabel: 'LL',
      monthYearA11yLabel: 'MMMM YYYY'
    },
};

@Component({
    selector: 'app-dialog-new-ticket',
    templateUrl: './dialog-new-ticket.component.html',
    styleUrls: ['./dialog-new-ticket.component.scss'],
    providers: [
      { provide: MAT_DATE_FORMATS, useValue: MY_DATE_FORMATS }
    ]
})

export class DialogNewTicketComponent {

  constructor(public dialogRef: MatDialogRef<DialogNewTicketComponent>) { }

  // Define the form group
  //@ts-ignore
  form: FormGroup;

  ngOnInit() {
    // Initialize the form with current date and set the field as disabled
    this.form = new FormGroup({
      category: new FormControl(''),
      dateOfIssue: new FormControl({ value: new Date(), disabled: true }),
      description: new FormControl('')
    });
  }

  // Your form submit function
  submitForm() {
    if (this.form.valid) {
      const formData = this.form.value;
      // Handle the form submission
      console.log(formData);
    }
  }

  onNoClick(): void {
    // Close the dialog or navigate away
    this.dialogRef.close();
  }
}