import { Component, Inject, OnInit } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';

export interface LogEntry {
  aid: string;
  type: string;
  pid: string;
  ts: string;
}

@Component({
  selector: 'app-dialog-publishing-log',
  templateUrl: './dialog-publishing-log.component.html',
  styleUrls: ['./dialog-publishing-log.component.scss']
})
export class DialogPublishingLogComponent implements OnInit {
  displayedColumns: string[] = ['aid', 'type', 'pid', 'ts'];
  dataSource = new MatTableDataSource<LogEntry>();
  totalLength = 100; // Set the total length according to your data
  searchQuery: string = '';
  selectedSort: string = 'newest';

  constructor(
    public dialogRef: MatDialogRef<DialogPublishingLogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: LogEntry[]
  ) {}

  ngOnInit(): void {
    this.dataSource.data = this.data;
  }

  onClose(): void {
    this.dialogRef.close();
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getTypeClass(type: string): string {
    switch (type) {
      case 'DATASET':
        return 'dataset';
      case 'SOFTWARE':
        return 'software';
      case 'TUTORIAL':
        return 'tutorial';
      default:
        return '';
    }
  }
}