import { Component, Inject, OnInit } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { MatTableDataSource } from '@angular/material/table';

export interface TradingLogEntry {
  txid: string;
  amount: number;
  oid: string;
  ts: Date;
}

@Component({
  selector: 'app-dialog-trading-log',
  templateUrl: './dialog-trading-log.component.html',
  styleUrls: ['./dialog-trading-log.component.scss']
})
export class DialogTradingLogComponent implements OnInit {
  displayedColumns: string[] = ['txid', 'amount', 'oid', 'ts'];
  dataSource = new MatTableDataSource<TradingLogEntry>();
  totalLength = 100; // Set the total length according to your data
  searchQuery: string = '';
  selectedSort: string = 'newest';

  constructor(
    public dialogRef: MatDialogRef<DialogTradingLogComponent>,
    @Inject(MAT_DIALOG_DATA) public data: TradingLogEntry[]
  ) {}

  ngOnInit(): void {
    this.dataSource.data = this.data;
  }

  onClose(): void {
    this.dialogRef.close();
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }
}