import { Component } from '@angular/core';
import { FormBuilder, FormControl, FormGroup } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';

@Component({
    selector: 'app-dialog-view-ticket',
    templateUrl: './dialog-view-ticket.component.html',
    styleUrls: ['./dialog-view-ticket.component.scss']
})

export class DialogViewTicketComponent {

  // Define the form group
  //@ts-ignore
  form: FormGroup;

  constructor(
    private fb: FormBuilder,
    private dialogRef: MatDialogRef<DialogViewTicketComponent>
  ) {
    this.form = this.fb.group({
      category: [{ value: 'technical', disabled: true }],
      dateOfIssue: [{value: new Date(), disabled: true }],
      description: [{ value: '', disabled: true }]
    });
  }

  ngOnInit(): void {}

  onNoClick(): void {
    // Close the dialog or navigate away
    this.dialogRef.close();
  }
}