import { inject } from "@angular/core";
import { OpenAPIService } from "src/app/services/open-api.service";
import { IframeComponent, IframeProps } from "../iframe/iframe.component";
export interface TagQueryEntry {
    name: string,
    type: string
}

export interface SortQuery {
    field: string,
    order: "asc" | "desc"

}
// This class implements the methods used by the pages the list data elements
export class ElementList {
    openAPIService: OpenAPIService = inject(OpenAPIService);
    iframeProps: IframeProps | null = null;
    iframe: IframeComponent | null = null
    constructor() {
        //@ts-ignore
        window.l = this
    }
    // Search query 
    search(term: string) {
        this.iframe?.sendMessage({ action: "search", value: term });
    }

    // Filter elements by tagname
    filterByTags(tagNames: TagQueryEntry[] | null = null) {
        this.iframe?.sendMessage({ action: "tagFilter", value: tagNames });
    }

    // Filter elements by date
    filterByDate(startDate: Date | null = null, endDate: Date | null = null) {
        if (startDate === null && endDate === null) {
            this.filter({})
            return
        }
        const $and: any[] = []
        if (startDate) $and.push({ updatedAt: { $gte: startDate } })
        if (endDate) $and.push({ updatedAt: { $lte: endDate } })
        this.filter({ $and })
    }

    // Sort elements
    sort(queries: SortQuery[]) {
        const sort: any = {}
        for (const { field, order } of queries) {
            const value = order === "desc" ? -1 : 1
            sort[field] = value
        }
        this.iframe?.sendMessage({ action: "setSort", value: sort });
    }

    // Generic element filter using a Mongo Query
    filter(query: any) {
        this.iframe?.sendMessage({ action: "setFilter", value: query });
    }
}