import { Component, Inject } from '@angular/core';
import { Router } from '@angular/router';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';

@Component({
  selector: 'app-pat-dialog',
  templateUrl: './pat-dialog.component.html',
  styleUrls: ['./pat-dialog.component.scss'],
})
export class PatDialogComponent {
  constructor(
    private dialogRef: MatDialogRef<PatDialogComponent>,
    private router: Router,
    @Inject(MAT_DIALOG_DATA) public data: any
  ) {}

  close() {
    this.dialogRef.close();
  }

  proceed() {
    this.dialogRef.close();

    // Prepare query parameters including unit type data
    const queryParams: any = {
      aid: this.data.assetId,
      title: this.data.assetTitle,
    };

    // Add complete form state if available
    if (this.data.formState) {
      const formState = this.data.formState;

      // Unit type parameters
      if (formState.selectedUnit)
        queryParams.selectedUnit = formState.selectedUnit;
      if (formState.duration !== undefined)
        queryParams.duration = formState.duration;
      if (formState.durationType)
        queryParams.durationType = formState.durationType;
      if (formState.retrievals !== undefined)
        queryParams.retrievals = formState.retrievals;
      if (formState.volume !== undefined) queryParams.volume = formState.volume;
      if (formState.volumeType) queryParams.volumeType = formState.volumeType;

      // All other form fields
      if (formState.title) queryParams.offeringTitle = formState.title;
      if (formState.summary) queryParams.summary = formState.summary;
      if (formState.price) queryParams.price = formState.price;
      if (formState.scope) queryParams.scope = formState.scope;
      if (formState.license) queryParams.license = formState.license;
      if (formState.sla) queryParams.sla = formState.sla;
      if (formState.tid) queryParams.tid = formState.tid;
      if (formState.cdsinst) queryParams.cdsinst = formState.cdsinst;
    }

    this.router.navigate(['/pat'], {
      queryParams: queryParams,
    });
  }
}