import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { AuthService } from 'src/app/auth/auth.service';
import { ChatService } from 'src/app/services/chat.service';

@Component({
  selector: 'app-sticky-menu',
  templateUrl: './sticky-menu.component.html',
  styleUrls: ['./sticky-menu.component.scss']
})
export class StickyMenuComponent implements OnInit {

  showChatbot: boolean = false;

  constructor(
    private router: Router,
    private authService: AuthService,
    private chatService: ChatService
  ) { }

  ngOnInit() {
  }

  navigateTo(page: string) {
    // Allow access to /fdac without authentication
    if (page === '/fdac' || page === '/regulation-tools' || page === '/learning-centre' || page === '/under-construction-chatbot' ) {
      this.router.navigate([page]);
    } else {
      const token = this.authService.getToken();
      if (token) {
        this.router.navigate([page]);
      } else {
        this.router.navigate(['/login']);
      }
    }
  }

  toggleChatbot() {
    this.chatService.toggleChatbot();
  }

  isActive(page: string): boolean {
    // Return true if the current URL matches the page route.
    // You can use router.url directly or subscribe to router events if needed.
    return this.router.url === page;
  }
}